/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.external.glassfish.hk2.utilities.general;

import java.lang.annotation.ElementType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.validator.HibernateValidator;
import org.mvplugins.multiverse.external.glassfish.hk2.utilities.general.internal.MessageInterpolatorImpl;
import org.mvplugins.multiverse.external.jakarta.validation.MessageInterpolator;
import org.mvplugins.multiverse.external.jakarta.validation.Path;
import org.mvplugins.multiverse.external.jakarta.validation.TraversableResolver;
import org.mvplugins.multiverse.external.jakarta.validation.Validation;
import org.mvplugins.multiverse.external.jakarta.validation.Validator;
import org.mvplugins.multiverse.external.jakarta.validation.ValidatorContext;
import org.mvplugins.multiverse.external.jakarta.validation.ValidatorFactory;

public class ValidatorUtilities {
    private static final ReentrantLock slock = new ReentrantLock();
    private static final TraversableResolver TRAVERSABLE_RESOLVER = new TraversableResolver(){

        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }

        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }
    };
    private static Validator validator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Validator initializeValidator() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HibernateValidator.class.getClassLoader());
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            ValidatorContext validatorContext = validatorFactory.usingContext();
            validatorContext.messageInterpolator((MessageInterpolator)new MessageInterpolatorImpl());
            Validator validator = validatorContext.traversableResolver(TRAVERSABLE_RESOLVER).getValidator();
            return validator;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static Validator getValidator() {
        slock.lock();
        try {
            if (validator == null) {
                validator = AccessController.doPrivileged(new PrivilegedAction<Validator>(){

                    @Override
                    public Validator run() {
                        return ValidatorUtilities.initializeValidator();
                    }
                });
            }
            if (validator == null) {
                throw new IllegalStateException("Could not find a jakarta.validator");
            }
            Validator validator = ValidatorUtilities.validator;
            return validator;
        }
        finally {
            slock.unlock();
        }
    }
}

