/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.location;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.util.NumberConversions;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Try;

@SerializableAs(value="UnloadedWorldLocation")
public final class UnloadedWorldLocation
extends Location {
    private String worldName;

    public static UnloadedWorldLocation fromLocation(@NotNull Location location) {
        return new UnloadedWorldLocation(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public UnloadedWorldLocation(@Nullable String worldName, double x, double y, double z) {
        super(null, x, y, z);
        this.setWorldName(worldName);
    }

    public UnloadedWorldLocation(@Nullable String worldName, double x, double y, double z, float yaw, float pitch) {
        super(null, x, y, z, yaw, pitch);
        this.setWorldName(worldName);
    }

    public UnloadedWorldLocation(@Nullable World world, double x, double y, double z) {
        super(null, x, y, z);
        this.setWorldName(world == null ? null : world.getName());
    }

    public UnloadedWorldLocation(@Nullable World world, double x, double y, double z, float yaw, float pitch) {
        super(null, x, y, z, yaw, pitch);
        this.setWorldName(world == null ? null : world.getName());
    }

    public UnloadedWorldLocation(@NotNull Location location) {
        this(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public Location toBukkitLocation() {
        return new Location(this.getWorld(), this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    public void setWorldName(@Nullable String worldName) {
        this.worldName = worldName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorld(@Nullable World world) {
        this.worldName = world == null ? null : world.getName();
    }

    @Nullable
    public World getWorld() {
        if (this.worldName == null) {
            return null;
        }
        return Bukkit.getWorld((String)this.worldName);
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.worldName != null) {
            data.put("world", this.worldName);
        }
        data.put("x", this.getX());
        data.put("y", this.getY());
        data.put("z", this.getZ());
        data.put("yaw", Float.valueOf(this.getYaw()));
        data.put("pitch", Float.valueOf(this.getPitch()));
        return data;
    }

    @NotNull
    public static Location deserialize(@NotNull Map<String, Object> args) {
        return new UnloadedWorldLocation(args.containsKey("world") ? args.get("world").toString() : null, NumberConversions.toDouble((Object)args.get("x")), NumberConversions.toDouble((Object)args.get("y")), NumberConversions.toDouble((Object)args.get("z")), NumberConversions.toFloat((Object)args.get("yaw")), NumberConversions.toFloat((Object)args.get("pitch")));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        String otherWorldName = (String)Try.of(() -> {
            String string;
            if (other instanceof UnloadedWorldLocation) {
                UnloadedWorldLocation unloadedWorldLocation = (UnloadedWorldLocation)other;
                string = unloadedWorldLocation.worldName;
            } else {
                string = other.getWorld().getName();
            }
            return string;
        }).getOrNull();
        if (!Objects.equals(this.worldName, otherWorldName)) {
            return false;
        }
        if (Double.doubleToLongBits(this.getX()) != Double.doubleToLongBits(other.getX())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getY()) != Double.doubleToLongBits(other.getY())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getZ()) != Double.doubleToLongBits(other.getZ())) {
            return false;
        }
        if (Float.floatToIntBits(this.getPitch()) != Float.floatToIntBits(other.getPitch())) {
            return false;
        }
        return Float.floatToIntBits(this.getYaw()) == Float.floatToIntBits(other.getYaw());
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + this.worldName.hashCode();
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.getX()) ^ Double.doubleToLongBits(this.getX()) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.getY()) ^ Double.doubleToLongBits(this.getY()) >>> 32);
        hash = 19 * hash + (int)(Double.doubleToLongBits(this.getZ()) ^ Double.doubleToLongBits(this.getZ()) >>> 32);
        hash = 19 * hash + Float.floatToIntBits(this.getPitch());
        hash = 19 * hash + Float.floatToIntBits(this.getYaw());
        return hash;
    }

    public String toString() {
        return "Location{world=" + this.worldName + ",x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + ",pitch=" + this.getPitch() + ",yaw=" + this.getYaw() + "}";
    }
}

