/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.generators;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.FileUtils;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.world.generators.GeneratorPlugin;
import org.mvplugins.multiverse.core.world.generators.SimpleGeneratorPlugin;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public final class GeneratorProvider
implements Listener {
    private final Map<String, String> defaultGenerators;
    private final Map<String, GeneratorPlugin> generatorPlugins;
    private final FileUtils fileUtils;

    @Inject
    GeneratorProvider(@NotNull MultiverseCore multiverseCore, @NotNull FileUtils fileUtils) {
        this.fileUtils = fileUtils;
        this.defaultGenerators = new HashMap<String, String>();
        this.generatorPlugins = new HashMap<String, GeneratorPlugin>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)multiverseCore);
        this.loadDefaultWorldGenerators();
        this.loadPluginGenerators();
    }

    private void loadDefaultWorldGenerators() {
        File bukkitConfigFile = this.fileUtils.getBukkitConfig();
        if (bukkitConfigFile == null) {
            CoreLogging.warning("Any default world generators will not be loaded!", new Object[0]);
            return;
        }
        YamlConfiguration bukkitConfig = YamlConfiguration.loadConfiguration((File)bukkitConfigFile);
        ConfigurationSection worldSection = bukkitConfig.getConfigurationSection("worlds");
        if (worldSection != null) {
            Set keys = worldSection.getKeys(false);
            keys.forEach(arg_0 -> this.lambda$loadDefaultWorldGenerators$0((FileConfiguration)bukkitConfig, arg_0));
        }
    }

    private void loadPluginGenerators() {
        Arrays.stream(Bukkit.getPluginManager().getPlugins()).forEach(plugin -> {
            if (this.testIsGeneratorPlugin((Plugin)plugin)) {
                this.registerGeneratorPlugin(new SimpleGeneratorPlugin(plugin.getName()));
            }
        });
    }

    private boolean testIsGeneratorPlugin(Plugin plugin) {
        String worldName = Bukkit.getWorlds().stream().findFirst().map(WorldInfo::getName).orElse("world");
        return Try.of(() -> plugin.getDefaultWorldGenerator(worldName, "") != null).recover(IllegalArgumentException.class, true).recover(throwable -> {
            CoreLogging.warning("Plugin %s threw an exception when testing if it is a generator plugin!", plugin.getName());
            throwable.printStackTrace();
            return false;
        }).getOrElse(false);
    }

    @Nullable
    public String getDefaultGeneratorForWorld(String worldName) {
        return this.defaultGenerators.getOrDefault(worldName, null);
    }

    public boolean registerGeneratorPlugin(@NotNull GeneratorPlugin generatorPlugin) {
        GeneratorPlugin registeredGenerator = this.generatorPlugins.get(generatorPlugin.getPluginName());
        if (registeredGenerator == null || registeredGenerator instanceof SimpleGeneratorPlugin) {
            this.generatorPlugins.put(generatorPlugin.getPluginName(), generatorPlugin);
            CoreLogging.finer("Registered generator plugin: %s", generatorPlugin.getPluginName());
            return true;
        }
        CoreLogging.severe("Generator plugin with name %s is already registered!", generatorPlugin.getPluginName());
        return false;
    }

    @Nullable
    public String parseGeneratorString(@NotNull String worldName, @Nullable String generatorString) {
        return Strings.isNullOrEmpty((String)generatorString) ? this.getDefaultGeneratorForWorld(worldName) : generatorString;
    }

    public boolean unregisterGeneratorPlugin(@NotNull String pluginName) {
        if (this.generatorPlugins.containsKey(pluginName)) {
            this.generatorPlugins.remove(pluginName);
            return true;
        }
        CoreLogging.severe("Generator plugin with name %s is not registered!", pluginName);
        return false;
    }

    public boolean isGeneratorPluginRegistered(@NotNull String pluginName) {
        return this.generatorPlugins.containsKey(pluginName);
    }

    @Nullable
    public GeneratorPlugin getGeneratorPlugin(@NotNull String pluginName) {
        return this.generatorPlugins.get(pluginName);
    }

    public Collection<String> suggestGeneratorString(@Nullable String currentInput) {
        String[] genSpilt = currentInput == null ? new String[]{} : REPatterns.COLON.split(currentInput, 2);
        String generatorName = genSpilt[0];
        String generatorId = genSpilt.length > 1 ? genSpilt[1] : "";
        return this.generatorPlugins.entrySet().stream().flatMap(entry -> {
            Collection<String> ids = ((GeneratorPlugin)entry.getValue()).suggestIds(((String)entry.getKey()).equals(generatorName) ? generatorId : "");
            if (ids.isEmpty()) {
                return Stream.of((String)entry.getKey());
            }
            return ids.stream().map(id -> Strings.isNullOrEmpty((String)id) ? (String)entry.getKey() : (String)entry.getKey() + ":" + id);
        }).toList();
    }

    public Collection<GeneratorPlugin> getRegisteredGeneratorPlugins() {
        return this.generatorPlugins.values();
    }

    @EventHandler
    private void onPluginEnable(PluginEnableEvent event) {
        if (!this.testIsGeneratorPlugin(event.getPlugin())) {
            CoreLogging.finest("Plugin %s is not a generator plugin.", event.getPlugin().getName());
            return;
        }
        if (!this.registerGeneratorPlugin(new SimpleGeneratorPlugin(event.getPlugin().getName()))) {
            CoreLogging.severe("Failed to register generator plugin %s!", event.getPlugin().getName());
        }
    }

    @EventHandler
    private void onPluginDisable(PluginDisableEvent event) {
        if (!this.isGeneratorPluginRegistered(event.getPlugin().getName())) {
            CoreLogging.finest("Plugin %s is not a generator plugin.", event.getPlugin().getName());
            return;
        }
        if (!this.unregisterGeneratorPlugin(event.getPlugin().getName())) {
            CoreLogging.severe("Failed to unregister generator plugin %s!", event.getPlugin().getName());
        }
    }

    private /* synthetic */ void lambda$loadDefaultWorldGenerators$0(FileConfiguration bukkitConfig, String key) {
        this.defaultGenerators.put(key, bukkitConfig.getString("worlds." + key + ".generator", ""));
    }
}

