/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.entity;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.entity.SpawnCategoryConfig;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;

public final class EntitySpawnConfig {
    private final Map<SpawnCategory, SpawnCategoryConfig> spawnCategoriesConfig;

    EntitySpawnConfig(Map<SpawnCategory, SpawnCategoryConfig> spawnCategoriesConfig) {
        this.spawnCategoriesConfig = spawnCategoriesConfig;
    }

    public SpawnCategoryConfig getSpawnCategoryConfig(SpawnCategory spawnCategory) {
        return this.spawnCategoriesConfig.computeIfAbsent(spawnCategory, computeSpawnCategory -> new SpawnCategoryConfig((SpawnCategory)computeSpawnCategory, (ConfigurationSection)new MemoryConfiguration()));
    }

    public boolean shouldAllowSpawn(Entity entity) {
        return this.getSpawnCategoryConfig(entity.getSpawnCategory()).shouldAllowSpawn(entity);
    }

    public void applyConfigToWorld() {
        this.spawnCategoriesConfig.values().forEach(SpawnCategoryConfig::applyConfigToWorld);
    }

    public String toString() {
        return "MobsSpawnConfig{spawnCategoriesConfig=" + StringFormatter.join(this.spawnCategoriesConfig.values(), ", ") + "}";
    }

    @ApiStatus.Internal
    public ConfigurationSection toSection() {
        MemoryConfiguration section = new MemoryConfiguration();
        this.spawnCategoriesConfig.forEach((spawnCategory, spawnCategoryConfig) -> section.set(spawnCategory.toString().toLowerCase(), (Object)spawnCategoryConfig.saveSection()));
        return section;
    }

    @ApiStatus.Internal
    public static EntitySpawnConfig fromSection(ConfigurationSection section) {
        HashMap<SpawnCategory, SpawnCategoryConfig> spawnCategoriesConfig = new HashMap<SpawnCategory, SpawnCategoryConfig>();
        section.getValues(false).forEach((key, value) -> {
            if (!(value instanceof ConfigurationSection)) {
                CoreLogging.warning("Invalid spawn category config for " + key + ": " + String.valueOf(value), new Object[0]);
                return;
            }
            ConfigurationSection sectionPart = (ConfigurationSection)value;
            SpawnCategory spawnCategory = SpawnCategory.valueOf((String)key.toUpperCase());
            spawnCategoriesConfig.put(spawnCategory, new SpawnCategoryConfig(spawnCategory, sectionPart));
        });
        return new EntitySpawnConfig(spawnCategoriesConfig);
    }

    @ApiStatus.Internal
    public void setWorldRef(MultiverseWorld world) {
        this.spawnCategoriesConfig.forEach((spawnCategory, spawnCategoryConfig) -> spawnCategoryConfig.setWorldRef(world));
    }
}

