/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.result;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;

public final class AttemptsAggregate<T, F extends FailureReason> {
    private final List<Attempt<T, F>> successAttempts;
    private final List<Attempt<T, F>> failureAttempts;

    public static <T, F extends FailureReason> AttemptsAggregate<T, F> allOf(List<Attempt<T, F>> attempts) {
        return new AttemptsAggregate<T, F>(attempts);
    }

    public static <T, F extends FailureReason> AttemptsAggregate<T, F> allOf(Attempt<T, F> ... attempts) {
        return new AttemptsAggregate<T, F>(List.of(attempts));
    }

    public static <T, F extends FailureReason> AttemptsAggregate<T, F> emptySuccess() {
        return new AttemptsAggregate<T, F>(Collections.emptyList());
    }

    private AttemptsAggregate(List<Attempt<T, F>> attempts) {
        this.successAttempts = attempts.stream().filter(Attempt::isSuccess).toList();
        this.failureAttempts = attempts.stream().filter(Attempt::isFailure).toList();
    }

    public AttemptsAggregate<T, F> onSuccess(Runnable runnable) {
        if (this.hasSuccess()) {
            runnable.run();
        }
        return this;
    }

    public AttemptsAggregate<T, F> onFailure(Runnable runnable) {
        if (this.hasFailure()) {
            runnable.run();
        }
        return this;
    }

    public AttemptsAggregate<T, F> onSuccess(Consumer<List<Attempt<T, F>>> successConsumer) {
        if (this.hasSuccess()) {
            successConsumer.accept(this.successAttempts);
        }
        return this;
    }

    public AttemptsAggregate<T, F> onFailure(Consumer<List<Attempt<T, F>>> failureConsumer) {
        if (this.hasFailure()) {
            failureConsumer.accept(this.failureAttempts);
        }
        return this;
    }

    public AttemptsAggregate<T, F> onSuccessCount(Consumer<Integer> successConsumer) {
        if (this.hasSuccess()) {
            successConsumer.accept(this.successAttempts.size());
        }
        return this;
    }

    public AttemptsAggregate<T, F> onFailureCount(Consumer<Map<F, Long>> failureConsumer) {
        if (this.hasFailure()) {
            failureConsumer.accept(this.failureAttempts.stream().collect(Collectors.groupingBy(Attempt::getFailureReason, Collectors.counting())));
        }
        return this;
    }

    public boolean hasSuccess() {
        return this.failureAttempts.isEmpty() || !this.successAttempts.isEmpty();
    }

    public boolean hasFailure() {
        return !this.failureAttempts.isEmpty();
    }
}

