/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.permissions;

import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.permissions.PermissionUtils;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.external.jakarta.annotation.PostConstruct;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public final class CorePermissions {
    static final String JOINLOCATION_BYPASS = "mv.bypass.joinlocation";
    static final String WORLD_ACCESS = "multiverse.access";
    static final String WORLD_EXEMPT = "multiverse.exempt";
    static final String GAMEMODE_BYPASS = "mv.bypass.gamemode";
    static final String PLAYERLIMIT_BYPASS = "mv.bypass.playerlimit";
    static final String TELEPORT = "multiverse.teleport";
    static final String SPAWN = "multiverse.core.spawn";
    private final PluginManager pluginManager;

    @Inject
    CorePermissions(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @PostConstruct
    void registerBasePermissions() {
        this.pluginManager.addPermission(new Permission(JOINLOCATION_BYPASS, PermissionDefault.FALSE));
        CoreLogging.fine("Successfully registered base permissions", new Object[0]);
    }

    public Try<Void> addWorldPermissions(@NotNull MultiverseWorld world) {
        return Try.run(() -> {
            this.pluginManager.addPermission(new Permission(PermissionUtils.concatPermission(WORLD_ACCESS, world.getName()), PermissionDefault.OP));
            this.pluginManager.addPermission(new Permission(PermissionUtils.concatPermission(WORLD_EXEMPT, world.getName()), PermissionDefault.OP));
            this.pluginManager.addPermission(new Permission(PermissionUtils.concatPermission(GAMEMODE_BYPASS, world.getName()), PermissionDefault.FALSE));
            this.pluginManager.addPermission(new Permission(PermissionUtils.concatPermission(PLAYERLIMIT_BYPASS, world.getName()), PermissionDefault.FALSE));
            this.pluginManager.addPermission(new Permission(PermissionUtils.concatPermission(SPAWN, world.getName()), PermissionDefault.OP));
            this.pluginManager.addPermission(new Permission(PermissionUtils.concatPermission(SPAWN, "self", world.getName()), PermissionDefault.OP));
            this.pluginManager.addPermission(new Permission(PermissionUtils.concatPermission(SPAWN, "other", world.getName()), PermissionDefault.OP));
            CoreLogging.fine("Successfully registered permissions for world %s", world.getName());
        });
    }

    public Try<Void> removeWorldPermissions(@NotNull MultiverseWorld world) {
        return Try.run(() -> {
            this.pluginManager.removePermission(PermissionUtils.concatPermission(WORLD_ACCESS, world.getName()));
            this.pluginManager.removePermission(PermissionUtils.concatPermission(WORLD_EXEMPT, world.getName()));
            this.pluginManager.removePermission(PermissionUtils.concatPermission(GAMEMODE_BYPASS, world.getName()));
            this.pluginManager.removePermission(PermissionUtils.concatPermission(PLAYERLIMIT_BYPASS, world.getName()));
            this.pluginManager.removePermission(PermissionUtils.concatPermission(SPAWN, "self", world.getName()));
            this.pluginManager.removePermission(PermissionUtils.concatPermission(SPAWN, "other", world.getName()));
            CoreLogging.fine("Successfully removed permissions for world %s", world.getName());
        });
    }

    public Try<Void> addDestinationPermissions(@NotNull Destination destination) {
        return Try.run(() -> {
            this.pluginManager.addPermission(new Permission(PermissionUtils.concatPermission(TELEPORT, "self", destination.getIdentifier()), PermissionDefault.OP));
            this.pluginManager.addPermission(new Permission(PermissionUtils.concatPermission(TELEPORT, "other", destination.getIdentifier()), PermissionDefault.OP));
            CoreLogging.fine("Successfully registered permissions for destination %s", destination.getIdentifier());
        });
    }

    public Try<Void> removeDestinationPermissions(@NotNull Destination destination) {
        return Try.run(() -> {
            this.pluginManager.removePermission(PermissionUtils.concatPermission(TELEPORT, "self", destination.getIdentifier()));
            this.pluginManager.removePermission(PermissionUtils.concatPermission(TELEPORT, "other", destination.getIdentifier()));
            CoreLogging.fine("Successfully removed permissions for destination %s", destination.getIdentifier());
        });
    }
}

