/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.listeners;

import org.bukkit.Material;
import org.bukkit.PortalType;
import org.bukkit.block.BlockState;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.IgnoreIfCancelled;
import org.mvplugins.multiverse.core.listeners.CoreListener;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class MVPortalListener
implements CoreListener {
    private final CoreConfig config;
    private final WorldManager worldManager;

    @Inject
    MVPortalListener(@NotNull CoreConfig config, @NotNull WorldManager worldManager) {
        this.config = config;
        this.worldManager = worldManager;
    }

    @EventMethod
    @IgnoreIfCancelled
    public void portalCreate(PortalCreateEvent event) {
        CoreLogging.fine("Attempting to create portal at '%s' with reason: %s", event.getWorld().getName(), event.getReason());
        this.worldManager.getLoadedWorld(event.getWorld()).peek(world -> {
            PortalType targetType = this.getPortalType(event);
            if (targetType == PortalType.CUSTOM) {
                return;
            }
            if (!world.getPortalForm().isPortalAllowed(targetType)) {
                CoreLogging.fine("Cancelling creation of %s portal because portalForm disallows.", targetType);
                event.setCancelled(true);
            }
        }).onEmpty(() -> CoreLogging.fine("World '%s' is not managed by Multiverse! Ignoring at PortalCreateEvent.", event.getWorld().getName()));
    }

    private PortalType getPortalType(PortalCreateEvent event) {
        return switch (event.getReason()) {
            case PortalCreateEvent.CreateReason.FIRE -> {
                for (BlockState block : event.getBlocks()) {
                    if (block.getType() != Material.NETHER_PORTAL) continue;
                    yield PortalType.NETHER;
                }
                yield PortalType.CUSTOM;
            }
            case PortalCreateEvent.CreateReason.NETHER_PAIR -> PortalType.NETHER;
            case PortalCreateEvent.CreateReason.END_PLATFORM -> PortalType.ENDER;
            default -> {
                CoreLogging.fine("Portal created is not NETHER or ENDER type. Ignoring...", new Object[0]);
                yield PortalType.CUSTOM;
            }
        };
    }

    @EventMethod
    @IgnoreIfCancelled
    public void playerInteract(PlayerInteractEvent event) {
        if (this.isCreateEndPortalInteraction(event)) {
            return;
        }
        this.worldManager.getLoadedWorld(event.getPlayer().getWorld()).peek(world -> {
            if (!world.getPortalForm().isPortalAllowed(PortalType.ENDER)) {
                CoreLogging.fine("Cancelling creation of ENDER portal because portalForm disallows.", new Object[0]);
                event.setCancelled(true);
            }
        }).onEmpty(() -> CoreLogging.fine("World '%s' is not managed by Multiverse! Ignoring at PlayerInteractEvent.", event.getPlayer().getWorld().getName()));
    }

    private boolean isCreateEndPortalInteraction(PlayerInteractEvent event) {
        return event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getClickedBlock() == null || event.getClickedBlock().getType() != Material.END_PORTAL_FRAME || event.getItem() == null || event.getItem().getType() != Material.ENDER_EYE;
    }

    @EventMethod
    public void entityPortal(EntityPortalEvent event) {
        if (event.isCancelled() || event.getTo() == null) {
            return;
        }
        if (this.config.isUsingCustomPortalSearch()) {
            event.setSearchRadius(this.config.getCustomPortalSearchRadius());
        }
    }
}

