/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventPriority;
import org.mvplugins.multiverse.core.MultiverseCore;
import org.mvplugins.multiverse.core.command.queue.ConfirmMode;
import org.mvplugins.multiverse.core.config.CoreConfigNodes;
import org.mvplugins.multiverse.core.config.handle.CommentedConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.config.migration.ConfigMigrator;
import org.mvplugins.multiverse.core.config.migration.VersionMigrator;
import org.mvplugins.multiverse.core.config.migration.action.BooleanMigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.IntegerMigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.InvertBoolMigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.MoveMigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.SetMigratorAction;
import org.mvplugins.multiverse.core.teleportation.PassengerMode;
import org.mvplugins.multiverse.core.teleportation.PassengerModes;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.helpers.DimensionFinder;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public final class CoreConfig {
    public static final String CONFIG_FILENAME = "config.yml";
    private final Path configPath;
    private final CoreConfigNodes configNodes;
    private final CommentedConfigurationHandle configHandle;
    private final StringPropertyHandle stringPropertyHandle;

    @Inject
    CoreConfig(@NotNull MultiverseCore core, @NotNull CoreConfigNodes configNodes) {
        this.configPath = Path.of(core.getDataFolder().getPath(), CONFIG_FILENAME);
        this.configNodes = configNodes;
        this.configHandle = ((CommentedConfigurationHandle.Builder)((CommentedConfigurationHandle.Builder)CommentedConfigurationHandle.builder(this.configPath, configNodes.getNodes()).logger(CoreLogging.getLogger())).migrator(ConfigMigrator.builder(configNodes.version).addVersionMigrator(VersionMigrator.builder(5.0).addAction(MoveMigratorAction.of("multiverse-configuration.enforceaccess", "world.enforce-access")).addAction(BooleanMigratorAction.of("world.enforce-access")).addAction(MoveMigratorAction.of("multiverse-configuration.prefixchat", "messaging.enable-chat-prefix")).addAction(BooleanMigratorAction.of("messaging.enable-chat-prefix")).addAction(MoveMigratorAction.of("multiverse-configuration.prefixchatformat", "messaging.chat-prefix-format")).addAction(MoveMigratorAction.of("multiverse-configuration.teleportintercept", "world.teleport-intercept")).addAction(BooleanMigratorAction.of("world.teleport-intercept")).addAction(MoveMigratorAction.of("multiverse-configuration.firstspawnoverride", "spawn.first-spawn-override")).addAction(BooleanMigratorAction.of("spawn.first-spawn-override")).addAction(MoveMigratorAction.of("multiverse-configuration.displaypermerrors", "misc.debug-permissions")).addAction(MoveMigratorAction.of("multiverse-configuration.globaldebug", "misc.global-debug")).addAction(IntegerMigratorAction.of("misc.global-debug")).addAction(MoveMigratorAction.of("multiverse-configuration.silentstart", "misc.silent-start")).addAction(BooleanMigratorAction.of("misc.silent-start")).addAction(MoveMigratorAction.of("multiverse-configuration.firstspawnworld", "spawn.first-spawn-location")).addAction(MoveMigratorAction.of("multiverse-configuration.defaultportalsearch", "portal.use-custom-portal-search")).addAction(BooleanMigratorAction.of("portal.use-custom-portal-search")).addAction(InvertBoolMigratorAction.of("portal.use-custom-portal-search")).addAction(MoveMigratorAction.of("multiverse-configuration.portalsearchradius", "portal.custom-portal-search-radius")).addAction(IntegerMigratorAction.of("portal.custom-portal-search-radius")).addAction(MoveMigratorAction.of("multiverse-configuration.autopurge", "world.auto-purge-entities")).addAction(BooleanMigratorAction.of("world.auto-purge-entities")).addAction(MoveMigratorAction.of("multiverse-configuration.idonotwanttodonate", "misc.show-donation-message")).addAction(BooleanMigratorAction.of("misc.show-donation-message")).addAction(InvertBoolMigratorAction.of("misc.show-donation-message")).addAction(SetMigratorAction.of("command.show-legacy-aliases", true)).build()).addVersionMigrator(VersionMigrator.builder(5.1).addAction(MoveMigratorAction.of("world.teleport-intercept", "teleport.teleport-intercept")).addAction(MoveMigratorAction.of("world.resolve-alias-name", "command.resolve-alias-name")).build()).addVersionMigrator(VersionMigrator.builder(5.2).addAction(MoveMigratorAction.of("spawn.default-respawn-to-world-spawn", "world.enforce-respawn-at-world-spawn")).build()).build())).build();
        this.stringPropertyHandle = new StringPropertyHandle(this.configHandle);
    }

    private void migrateFromOldConfigFile() {
        String content;
        try {
            content = Files.readString(this.configPath);
        }
        catch (IOException e) {
            return;
        }
        content = content.replace("==: com.onarandombox.MultiverseCore.MultiverseCoreConfiguration", "");
        try {
            Files.writeString(this.configPath, (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Try<Void> load() {
        return Try.run(this::migrateFromOldConfigFile).flatMap(ignore -> this.configHandle.load()).onFailure(e -> {
            CoreLogging.severe("Failed to load Multiverse-Core config.yml!", new Object[0]);
            e.printStackTrace();
        });
    }

    public boolean isLoaded() {
        return this.configHandle.isLoaded();
    }

    public Try<Void> save() {
        return this.configHandle.save();
    }

    public StringPropertyHandle getStringPropertyHandle() {
        return this.stringPropertyHandle;
    }

    public Try<Void> setAutoImportDefaultWorlds(boolean autoImportDefaultWorlds) {
        return this.configHandle.set(this.configNodes.autoImportDefaultWorlds, autoImportDefaultWorlds);
    }

    public boolean getAutoImportDefaultWorlds() {
        return this.configHandle.get(this.configNodes.autoImportDefaultWorlds);
    }

    public Try<Void> setAutoImport3rdPartyWorlds(boolean autoImport3rdPartyWorlds) {
        return this.configHandle.set(this.configNodes.autoImport3rdPartyWorlds, autoImport3rdPartyWorlds);
    }

    public boolean getAutoImport3rdPartyWorlds() {
        return this.configHandle.get(this.configNodes.autoImport3rdPartyWorlds);
    }

    public Try<Void> setEnforceAccess(boolean enforceAccess) {
        return this.configHandle.set(this.configNodes.enforceAccess, enforceAccess);
    }

    public boolean getEnforceAccess() {
        return this.configHandle.get(this.configNodes.enforceAccess);
    }

    public Try<Void> setEnforceGameMode(boolean enforceGameMode) {
        return this.configHandle.set(this.configNodes.enforceGamemode, enforceGameMode);
    }

    public boolean getEnforceGameMode() {
        return this.configHandle.get(this.configNodes.enforceGamemode);
    }

    public Try<Void> setEnforceFlight(boolean enforceFlight) {
        return this.configHandle.set(this.configNodes.enforceFlight, enforceFlight);
    }

    public boolean getEnforceFlight() {
        return this.configHandle.get(this.configNodes.enforceFlight);
    }

    public Try<Void> setAutoPurgeEntities(boolean autopurge) {
        return this.configHandle.set(this.configNodes.autoPurgeEntities, autopurge);
    }

    public boolean isAutoPurgeEntities() {
        return this.configHandle.get(this.configNodes.autoPurgeEntities);
    }

    public Try<Void> setNetherWorldNameFormat(DimensionFinder.DimensionFormat netherWorldNameFormat) {
        return this.configHandle.set(this.configNodes.netherWorldNameFormat, netherWorldNameFormat);
    }

    public DimensionFinder.DimensionFormat getNetherWorldNameFormat() {
        return this.configHandle.get(this.configNodes.netherWorldNameFormat);
    }

    public Try<Void> setEndWorldNameFormat(DimensionFinder.DimensionFormat endWorldNameFormat) {
        return this.configHandle.set(this.configNodes.endWorldNameFormat, endWorldNameFormat);
    }

    public DimensionFinder.DimensionFormat getEndWorldNameFormat() {
        return this.configHandle.get(this.configNodes.endWorldNameFormat);
    }

    public Try<Void> setUseFinerTeleportPermissions(boolean useFinerTeleportPermissions) {
        return this.configHandle.set(this.configNodes.useFinerTeleportPermissions, useFinerTeleportPermissions);
    }

    public boolean getUseFinerTeleportPermissions() {
        return this.configHandle.get(this.configNodes.useFinerTeleportPermissions);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setPassengerMode(PassengerModes passengerMode) {
        return this.configHandle.set(this.configNodes.passengerMode, passengerMode);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public PassengerMode getPassengerMode() {
        return this.configHandle.get(this.configNodes.passengerMode);
    }

    public Try<Void> setConcurrentTeleportLimit(int concurrentTeleportLimit) {
        return this.configHandle.set(this.configNodes.concurrentTeleportLimit, concurrentTeleportLimit);
    }

    public int getConcurrentTeleportLimit() {
        return this.configHandle.get(this.configNodes.concurrentTeleportLimit);
    }

    public Try<Void> setTeleportIntercept(boolean teleportIntercept) {
        return this.configHandle.set(this.configNodes.teleportIntercept, teleportIntercept);
    }

    public boolean getTeleportIntercept() {
        return this.configHandle.get(this.configNodes.teleportIntercept);
    }

    public Try<Void> setFirstSpawnOverride(boolean firstSpawnOverride) {
        return this.configHandle.set(this.configNodes.firstSpawnOverride, firstSpawnOverride);
    }

    public Try<Void> setSafeLocationHorizontalSearchRadius(int searchRadius) {
        return this.configHandle.set(this.configNodes.safeLocationHorizontalSearchRadius, searchRadius);
    }

    public int getSafeLocationHorizontalSearchRadius() {
        return this.configHandle.get(this.configNodes.safeLocationHorizontalSearchRadius);
    }

    public Try<Void> setSafeLocationVerticalSearchRadius(int searchRadius) {
        return this.configHandle.set(this.configNodes.safeLocationVerticalSearchRadius, searchRadius);
    }

    public int getSafeLocationVerticalSearchRadius() {
        return this.configHandle.get(this.configNodes.safeLocationVerticalSearchRadius);
    }

    public boolean getFirstSpawnOverride() {
        return this.configHandle.get(this.configNodes.firstSpawnOverride);
    }

    public Try<Void> setFirstSpawnLocation(String firstSpawnWorld) {
        return this.configHandle.set(this.configNodes.firstSpawnLocation, firstSpawnWorld);
    }

    public String getFirstSpawnLocation() {
        return this.configHandle.get(this.configNodes.firstSpawnLocation);
    }

    public Try<Void> setEnableJoinDestination(boolean enableJoinDestination) {
        return this.configHandle.set(this.configNodes.enableJoinDestination, enableJoinDestination);
    }

    public boolean getEnableJoinDestination() {
        return this.configHandle.get(this.configNodes.enableJoinDestination);
    }

    public Try<Void> setJoinDestination(String alwaysSpawnDestination) {
        return this.configHandle.set(this.configNodes.joinDestination, alwaysSpawnDestination);
    }

    public String getJoinDestination() {
        return this.configHandle.get(this.configNodes.joinDestination);
    }

    public Try<Void> setDefaultRespawnInOverworld(boolean defaultRespawnInOverworld) {
        return this.configHandle.set(this.configNodes.defaultRespawnInOverworld, defaultRespawnInOverworld);
    }

    public boolean getDefaultRespawnInOverworld() {
        return this.configHandle.get(this.configNodes.defaultRespawnInOverworld);
    }

    public Try<Void> setDefaultRespawnWithinSameWorld(boolean defaultRespawnToWorldSpawn) {
        return this.configHandle.set(this.configNodes.defaultRespawnWithinSameWorld, defaultRespawnToWorldSpawn);
    }

    public boolean getDefaultRespawnWithinSameWorld() {
        return this.configHandle.get(this.configNodes.defaultRespawnWithinSameWorld);
    }

    public Try<Void> setEnforceRespawnAtWorldSpawn(boolean enforceRespawnAtWorldSpawn) {
        return this.configHandle.set(this.configNodes.enforceRespawnAtWorldSpawn, enforceRespawnAtWorldSpawn);
    }

    public boolean getEnforceRespawnAtWorldSpawn() {
        return this.configHandle.get(this.configNodes.enforceRespawnAtWorldSpawn);
    }

    public Try<Void> setUseCustomPortalSearch(boolean useDefaultPortalSearch) {
        return this.configHandle.set(this.configNodes.useCustomPortalSearch, useDefaultPortalSearch);
    }

    public boolean isUsingCustomPortalSearch() {
        return this.configHandle.get(this.configNodes.useCustomPortalSearch);
    }

    public Try<Void> setCustomPortalSearchRadius(int searchRadius) {
        return this.configHandle.set(this.configNodes.customPortalSearchRadius, searchRadius);
    }

    public int getCustomPortalSearchRadius() {
        return this.configHandle.get(this.configNodes.customPortalSearchRadius);
    }

    public Try<Void> setEnablePrefixChat(boolean prefixChat) {
        return this.configHandle.set(this.configNodes.enableChatPrefix, prefixChat);
    }

    public boolean isEnablePrefixChat() {
        return this.configHandle.get(this.configNodes.enableChatPrefix);
    }

    public Try<Void> setPrefixChatFormat(String prefixChatFormat) {
        return this.configHandle.set(this.configNodes.chatPrefixFormat, prefixChatFormat);
    }

    public String getPrefixChatFormat() {
        return this.configHandle.get(this.configNodes.chatPrefixFormat);
    }

    public Try<Void> setRegisterPapiHook(boolean registerPapiHook) {
        return this.configHandle.set(this.configNodes.registerPapiHook, registerPapiHook);
    }

    public boolean isRegisterPapiHook() {
        return this.configHandle.get(this.configNodes.registerPapiHook);
    }

    public Try<Void> setDefaultLocale(Locale defaultLocale) {
        return this.configHandle.set(this.configNodes.defaultLocale, defaultLocale);
    }

    public Locale getDefaultLocale() {
        return this.configHandle.get(this.configNodes.defaultLocale);
    }

    public Try<Void> setPerPlayerLocale(boolean perPlayerLocale) {
        return this.configHandle.set(this.configNodes.perPlayerLocale, perPlayerLocale);
    }

    public boolean getPerPlayerLocale() {
        return this.configHandle.get(this.configNodes.perPlayerLocale);
    }

    public Try<Void> setResolveAliasName(boolean resolveAliasInCommands) {
        return this.configHandle.set(this.configNodes.resolveAliasName, resolveAliasInCommands);
    }

    public boolean getResolveAliasName() {
        return this.configHandle.get(this.configNodes.resolveAliasName);
    }

    public Try<Void> setConfirmMode(ConfirmMode confirmMode) {
        return this.configHandle.set(this.configNodes.confirmMode, confirmMode);
    }

    public ConfirmMode getConfirmMode() {
        return this.configHandle.get(this.configNodes.confirmMode);
    }

    public Try<Void> setUseConfirmOtp(boolean useConfirmOtp) {
        return this.configHandle.set(this.configNodes.useConfirmOtp, useConfirmOtp);
    }

    public boolean getUseConfirmOtp() {
        return this.configHandle.get(this.configNodes.useConfirmOtp);
    }

    public Integer getConfirmTimeout() {
        return this.configHandle.get(this.configNodes.confirmTimeout);
    }

    public Try<Void> setConfirmTimeout(int confirmTimeout) {
        return this.configHandle.set(this.configNodes.confirmTimeout, confirmTimeout);
    }

    public boolean getShowLegacyAliases() {
        return this.configHandle.get(this.configNodes.showLegacyAliases);
    }

    public Try<Void> setShowLegacyAliases(boolean showLegacyAliases) {
        return this.configHandle.set(this.configNodes.showLegacyAliases, showLegacyAliases);
    }

    public Try<Void> setEventPriorityPlayerPortal(EventPriority eventPriorityPlayerPortal) {
        return this.configHandle.set(this.configNodes.eventPriorityPlayerPortal, eventPriorityPlayerPortal);
    }

    public EventPriority getEventPriorityPlayerPortal() {
        return this.configHandle.get(this.configNodes.eventPriorityPlayerPortal);
    }

    public Try<Void> setEventPriorityPlayerRespawn(EventPriority eventPriorityPlayerRespawn) {
        return this.configHandle.set(this.configNodes.eventPriorityPlayerRespawn, eventPriorityPlayerRespawn);
    }

    public EventPriority getEventPriorityPlayerRespawn() {
        return this.configHandle.get(this.configNodes.eventPriorityPlayerRespawn);
    }

    public Try<Void> getEventPriorityPlayerSpawnLocation(EventPriority eventPriorityPlayerSpawnLocation) {
        return this.configHandle.set(this.configNodes.eventPriorityPlayerSpawnLocation, eventPriorityPlayerSpawnLocation);
    }

    public EventPriority getEventPriorityPlayerSpawnLocation() {
        return this.configHandle.get(this.configNodes.eventPriorityPlayerSpawnLocation);
    }

    public Try<Void> setEventPriorityPlayerTeleport(EventPriority eventPriorityPlayerTeleport) {
        return this.configHandle.set(this.configNodes.eventPriorityPlayerTeleport, eventPriorityPlayerTeleport);
    }

    public EventPriority getEventPriorityPlayerTeleport() {
        return this.configHandle.get(this.configNodes.eventPriorityPlayerTeleport);
    }

    public Try<Void> setBukkitYmlPath(String bukkitYmlPath) {
        return this.configHandle.set(this.configNodes.bukkitYmlPath, bukkitYmlPath);
    }

    public String getBukkitYmlPath() {
        return this.configHandle.get(this.configNodes.bukkitYmlPath);
    }

    public Try<Void> setGlobalDebug(int globalDebug) {
        return this.configHandle.set(this.configNodes.globalDebug, globalDebug);
    }

    public int getGlobalDebug() {
        return this.configHandle.get(this.configNodes.globalDebug);
    }

    public Try<Void> setDebugPermissions(boolean debugPermissions) {
        return this.configHandle.set(this.configNodes.debugPermissions, debugPermissions);
    }

    public boolean getDebugPermissions() {
        return this.configHandle.get(this.configNodes.debugPermissions);
    }

    public Try<Void> setSilentStart(boolean silentStart) {
        return this.configHandle.set(this.configNodes.silentStart, silentStart);
    }

    public boolean getSilentStart() {
        return this.configHandle.get(this.configNodes.silentStart);
    }

    public Try<Void> setShowDonateMessage(boolean showDonateMessage) {
        return this.configHandle.set(this.configNodes.showDonationMessage, showDonateMessage);
    }

    public boolean isShowingDonateMessage() {
        return this.configHandle.get(this.configNodes.showDonationMessage);
    }

    @ApiStatus.Internal
    public FileConfiguration getConfig() {
        return (FileConfiguration)this.configHandle.getConfig();
    }
}

