/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.RemovePlayerFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.options.LoadWorldOptions;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class LoadCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final Flags flags;

    @Inject
    LoadCommand(@NotNull WorldManager worldManager, @NotNull Flags flags) {
        this.worldManager = worldManager;
        this.flags = flags;
    }

    @Subcommand(value="load")
    @CommandPermission(value="multiverse.core.load")
    @CommandCompletion(value="@mvworlds:scope=unloaded")
    @Syntax(value="<world>")
    @Description(value="{@@mv-core.load.description}")
    void onLoadCommand(MVCommandIssuer issuer, @Syntax(value="<world>") @Description(value="{@@mv-core.load.world.description}") MultiverseWorld world, @Optional @Syntax(value="[--remove-players]") @Description(value="") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.LOAD_LOADING, MessageReplacement.Replace.WORLD.with(world.getName()));
        this.worldManager.loadWorld(LoadWorldOptions.world(world).doFolderCheck(!parsedFlags.hasFlag(this.flags.skipFolderCheck))).onSuccess(newWorld -> {
            CoreLogging.fine("World load success: " + String.valueOf(newWorld), new Object[0]);
            issuer.sendInfo((MessageKeyProvider)MVCorei18n.LOAD_SUCCESS, MessageReplacement.Replace.WORLD.with(newWorld.getName()));
        }).onFailure(failure -> {
            CoreLogging.fine("World load failure: " + String.valueOf(failure), new Object[0]);
            issuer.sendError(failure.getFailureMessage());
        });
    }

    @Service
    private static final class Flags
    extends RemovePlayerFlags {
        private static final String NAME = "mvunload";
        private final CommandFlag skipFolderCheck = this.flag(((CommandFlag.Builder)CommandFlag.builder("--skip-folder-check").addAlias("-f")).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager) {
            super(NAME, flagsManager);
        }
    }

    @Service
    private static final class LegacyAlias
    extends LoadCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull WorldManager worldManager, @NotNull Flags flags) {
            super(worldManager, flags);
        }

        @Override
        @CommandAlias(value="mvload")
        void onLoadCommand(MVCommandIssuer issuer, MultiverseWorld world, String[] flagArray) {
            super.onLoadCommand(issuer, world, flagArray);
        }
    }
}

