/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.PageFilterFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.config.handle.PropertyModifyAction;
import org.mvplugins.multiverse.core.display.ContentDisplay;
import org.mvplugins.multiverse.core.display.filters.DefaultContentFilter;
import org.mvplugins.multiverse.core.display.handlers.PagedSendHandler;
import org.mvplugins.multiverse.core.display.handlers.SendHandler;
import org.mvplugins.multiverse.core.display.parsers.ListContentProvider;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.entity.SpawnCategoryConfig;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Single;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
@Subcommand(value="entity-spawn-config")
final class EntitySpawnConfigCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final PageFilterFlags flags;

    @Inject
    EntitySpawnConfigCommand(@NotNull WorldManager worldManager, @NotNull PageFilterFlags flags) {
        this.worldManager = worldManager;
        this.flags = flags;
    }

    @Subcommand(value="info")
    @CommandPermission(value="multiverse.core.entityspawnconfig.info")
    @CommandCompletion(value="@mvworlds:scope=both|@flags:resolveUntil=arg1,groupName=pagefilter @flags:groupName=pagefilter")
    @Syntax(value="[world] [--page <page>] [--filter <filter>]")
    @Description(value="")
    void onInfoCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") MultiverseWorld world, @Optional @Syntax(value="[--page <page>] [--filter <filter>]") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        ContentDisplay.create().addContent(ListContentProvider.forContent(this.getEntitySpawnConfigList(world))).withSendHandler((SendHandler)((PagedSendHandler)PagedSendHandler.create().withHeader(Message.of("==== [ Entity Spawn Config '" + world.getName() + "' ] ====", new MessageReplacement[0]))).withLinesPerPage(8).withTargetPage(parsedFlags.flagValue(this.flags.page, 1)).withFilter(parsedFlags.flagValue(this.flags.filter, DefaultContentFilter.get()))).send(issuer);
    }

    private List<String> getEntitySpawnConfigList(MultiverseWorld world) {
        ArrayList<String> list = new ArrayList<String>();
        Arrays.stream(SpawnCategory.values()).forEach(spawnCategory -> {
            list.add(spawnCategory.name() + ": ");
            SpawnCategoryConfig spawnCategoryConfig = world.getEntitySpawnConfig().getSpawnCategoryConfig((SpawnCategory)spawnCategory);
            list.add("  spawn: " + spawnCategoryConfig.isSpawn());
            list.add("  tick-rate: " + spawnCategoryConfig.getTickRate());
            list.add("  exceptions: " + StringFormatter.join(spawnCategoryConfig.getExceptions(), ", "));
        });
        return list;
    }

    @Subcommand(value="modify")
    @CommandPermission(value="multiverse.core.entityspawnconfig.modify")
    @CommandCompletion(value="@mvworlds:scope=both @spawncategories @propsmodifyaction @spawncategorypropsname @spawncategorypropsvalue")
    @Syntax(value="[world] <spawn-category> <set|add|reset|remove> <property> [value]")
    @Description(value="")
    void onModifyCommand(MVCommandIssuer issuer, @Flags(value="resolve=issuerAware") @Syntax(value="[world]") MultiverseWorld world, @Syntax(value="<spawn-category>") SpawnCategory spawnCategory, @Syntax(value="<set|add|reset|remove>") PropertyModifyAction action, @Syntax(value="<property>") String property, @Optional @Single @Syntax(value="[value]") @Nullable String value) {
        world.getEntitySpawnConfig().getSpawnCategoryConfig(spawnCategory).getStringPropertyHandle().modifyPropertyString(property, value, action).onSuccess(ignore -> issuer.sendMessage("Successfully set " + property + " to " + value + " for " + spawnCategory.name() + " in " + world.getName())).onFailure(e -> issuer.sendMessage("Unable to set " + property + " to " + value + " for " + spawnCategory.name() + " in " + world.getName() + ": " + e.getMessage()));
        this.worldManager.saveWorldsConfig();
    }
}

