/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.CommandValueFlag;
import org.mvplugins.multiverse.core.command.flag.FlagBuilder;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.commands.DumpsLogPoster;
import org.mvplugins.multiverse.core.commands.DumpsService;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class DumpsCommand
extends CoreCommand {
    private final DumpsService dumpsService;
    private final Flags flags;

    @Inject
    DumpsCommand(@NotNull DumpsService dumpsService, @NotNull Flags flags) {
        this.dumpsService = dumpsService;
        this.flags = flags;
    }

    @Subcommand(value="dumps")
    @CommandPermission(value="multiverse.core.dumps")
    @CommandCompletion(value="@flags:groupName=mvdumps")
    @Syntax(value="[--logs <mclogs | append>] [--upload <pastesdev | pastegg>] [--paranoid]")
    @Description(value="{@@mv-core.dumps.description}")
    void onDumpsCommand(MVCommandIssuer issuer, @Optional @Syntax(value="[--logs <mclogs | append>] [--upload <pastesdev | pastegg>] [--paranoid]") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        boolean paranoid = parsedFlags.hasFlag(this.flags.paranoid);
        DumpsLogPoster.LogsType logsType = parsedFlags.flagValue(this.flags.logs, DumpsLogPoster.LogsType.MCLOGS);
        DumpsLogPoster.UploadType servicesType = parsedFlags.flagValue(this.flags.upload, DumpsLogPoster.UploadType.PASTESDEV);
        this.dumpsService.postLogs(issuer, logsType, servicesType, paranoid);
    }

    @Service
    private static final class Flags
    extends FlagBuilder {
        private static final String NAME = "mvdumps";
        private final CommandValueFlag<DumpsLogPoster.LogsType> logs = (CommandValueFlag)this.flag(((CommandValueFlag.EnumBuilder)CommandValueFlag.enumBuilder("--logs", DumpsLogPoster.LogsType.class).addAlias("-l")).build());
        private final CommandValueFlag<DumpsLogPoster.UploadType> upload = (CommandValueFlag)this.flag(((CommandValueFlag.EnumBuilder)CommandValueFlag.enumBuilder("--upload", DumpsLogPoster.UploadType.class).addAlias("-u")).build());
        private final CommandFlag paranoid = this.flag(((CommandFlag.Builder)CommandFlag.builder("--paranoid").addAlias("-p")).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager) {
            super(NAME, flagsManager);
        }
    }
}

