/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class DebugCommand
extends CoreCommand {
    private final CoreConfig config;

    @Inject
    DebugCommand(@NotNull CoreConfig config) {
        this.config = config;
    }

    @Subcommand(value="debug")
    @CommandPermission(value="multiverse.core.debug")
    @Description(value="{@@mv-core.debug.info.description}")
    void onShowDebugCommand(BukkitCommandIssuer issuer) {
        this.displayDebugMode(issuer);
    }

    @Subcommand(value="debug")
    @CommandPermission(value="multiverse.core.debug")
    @CommandCompletion(value="@range:3")
    @Syntax(value="<{@@mv-core.debug.change.syntax}>")
    @Description(value="{@@mv-core.debug.change.description}")
    void onChangeDebugCommand(BukkitCommandIssuer issuer, @Syntax(value="<{@@mv-core.debug.change.syntax}>") @Description(value="{@@mv-core.debug.change.level.description}") int level) {
        this.config.setGlobalDebug(level);
        this.config.save();
        this.displayDebugMode(issuer);
    }

    private void displayDebugMode(BukkitCommandIssuer issuer) {
        int debugLevel = this.config.getGlobalDebug();
        if (debugLevel == 0) {
            issuer.sendInfo(MVCorei18n.DEBUG_INFO_OFF, new String[0]);
            return;
        }
        issuer.sendInfo(MVCorei18n.DEBUG_INFO_ON, "{level}", String.valueOf(debugLevel));
        CoreLogging.fine("Multiverse Debug ENABLED.", new Object[0]);
    }

    @Service
    private static final class LegacyAlias
    extends DebugCommand
    implements LegacyAliasCommand {
        @Inject
        public LegacyAlias(@NotNull CoreConfig config) {
            super(config);
        }

        @Override
        @CommandAlias(value="mvdebug")
        void onChangeDebugCommand(BukkitCommandIssuer issuer, int level) {
            super.onChangeDebugCommand(issuer, level);
        }
    }
}

