/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.anchor.AnchorManager;
import org.mvplugins.multiverse.core.anchor.MultiverseAnchor;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.command.context.issueraware.IssuerAwareValue;
import org.mvplugins.multiverse.core.command.context.issueraware.MultiverseWorldValue;
import org.mvplugins.multiverse.core.command.context.issueraware.PlayerArrayValue;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.config.handle.PropertyModifyAction;
import org.mvplugins.multiverse.core.config.node.functions.DefaultSuggesterProvider;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.permissions.CorePermissionsChecker;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.generators.GeneratorPlugin;
import org.mvplugins.multiverse.core.world.generators.GeneratorProvider;
import org.mvplugins.multiverse.external.acf.commands.BukkitCommandCompletionContext;
import org.mvplugins.multiverse.external.acf.commands.CommandCompletions;
import org.mvplugins.multiverse.external.acf.commands.CommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.PaperCommandCompletions;
import org.mvplugins.multiverse.external.acf.commands.RegisteredCommand;
import org.mvplugins.multiverse.external.acf.commands.RootCommand;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

@Service
public class MVCommandCompletions
extends PaperCommandCompletions {
    private final MVCommandManager commandManager;
    private final WorldManager worldManager;
    private final DestinationsProvider destinationsProvider;
    private final CoreConfig config;
    private final CorePermissionsChecker corePermissionsChecker;
    private final AnchorManager anchorManager;
    private final GeneratorProvider generatorProvider;

    @Inject
    MVCommandCompletions(@NotNull MVCommandManager mvCommandManager, @NotNull WorldManager worldManager, @NotNull DestinationsProvider destinationsProvider, @NotNull CoreConfig config, @NotNull CorePermissionsChecker corePermissionsChecker, @NotNull AnchorManager anchorManager, @NotNull GeneratorProvider generatorProvider) {
        super(mvCommandManager);
        this.commandManager = mvCommandManager;
        this.worldManager = worldManager;
        this.destinationsProvider = destinationsProvider;
        this.config = config;
        this.corePermissionsChecker = corePermissionsChecker;
        this.anchorManager = anchorManager;
        this.generatorProvider = generatorProvider;
        this.registerAsyncCompletion("anchornames", this::suggestAnchorNames);
        this.registerAsyncCompletion("commands", this::suggestCommands);
        this.registerAsyncCompletion("destinations", this::suggestDestinations);
        this.registerStaticCompletion("difficulties", this.suggestEnums(Difficulty.class));
        this.registerStaticCompletion("environments", this.suggestEnums(World.Environment.class));
        this.registerAsyncCompletion("flags", this::suggestFlags);
        this.registerStaticCompletion("gamemodes", this.suggestEnums(GameMode.class));
        this.registerStaticCompletion("gamerules", this::suggestGamerules);
        this.registerAsyncCompletion("gamerulesvalues", this::suggestGamerulesValues);
        this.registerAsyncCompletion("generatorplugins", this::suggestGeneratorPlugins);
        this.registerStaticCompletion("materials", this.suggestEnums(Material.class));
        this.registerStaticCompletion("mvconfigs", config.getStringPropertyHandle().getAllPropertyNames());
        this.registerAsyncCompletion("mvconfigvalues", this::suggestMVConfigValues);
        this.registerAsyncCompletion("mvworlds", this::suggestMVWorlds);
        this.registerAsyncCompletion("mvworldpropsname", this::suggestMVWorldPropsName);
        this.registerAsyncCompletion("mvworldpropsvalue", this::suggestMVWorldPropsValue);
        this.registerAsyncCompletion("playersarray", this::suggestPlayersArray);
        this.registerStaticCompletion("propsmodifyaction", this.suggestEnums(PropertyModifyAction.class));
        this.registerStaticCompletion("spawncategories", this.suggestEnums(SpawnCategory.class));
        this.registerAsyncCompletion("spawncategorypropsname", this::suggestSpawnCategoryPropsName);
        this.registerAsyncCompletion("spawncategorypropsvalue", this::suggestSpawnCategoryPropsValue);
        this.setDefaultCompletion("destinations", DestinationInstance.class);
        this.setDefaultCompletion("difficulties", Difficulty.class);
        this.setDefaultCompletion("environments", World.Environment.class);
        this.setDefaultCompletion("flags", String[].class);
        this.setDefaultCompletion("gamemodes", GameMode.class);
        this.setDefaultCompletion("gamerules", GameRule.class);
        this.setDefaultCompletion("mvworlds", LoadedMultiverseWorld.class);
    }

    @Override
    public CommandCompletions.CommandCompletionHandler registerCompletion(String id, CommandCompletions.CommandCompletionHandler<BukkitCommandCompletionContext> handler) {
        return super.registerCompletion(id, (C context) -> this.completeWithPreconditions((BukkitCommandCompletionContext)context, handler));
    }

    @Override
    public CommandCompletions.CommandCompletionHandler registerAsyncCompletion(String id, CommandCompletions.AsyncCommandCompletionHandler<BukkitCommandCompletionContext> handler) {
        return super.registerAsyncCompletion(id, context -> this.completeWithPreconditions((BukkitCommandCompletionContext)context, (CommandCompletions.CommandCompletionHandler<BukkitCommandCompletionContext>)handler));
    }

    private Collection<String> completeWithPreconditions(BukkitCommandCompletionContext context, CommandCompletions.CommandCompletionHandler<BukkitCommandCompletionContext> handler) {
        Boolean byIssuerForArg;
        if (context.hasConfig("playerOnly") && !context.getIssuer().isPlayer()) {
            return Collections.emptyList();
        }
        if (context.hasConfig("byIssuerForArg") && !(byIssuerForArg = Try.of(() -> context.getContextValueByName(IssuerAwareValue.class, context.getConfig("byIssuerForArg"))).map(IssuerAwareValue::isByIssuer).getOrElse(false)).booleanValue()) {
            return Collections.emptyList();
        }
        if (context.hasConfig("notByIssuerForArg") && (byIssuerForArg = Try.of(() -> context.getContextValueByName(IssuerAwareValue.class, context.getConfig("notByIssuerForArg"))).map(IssuerAwareValue::isByIssuer).getOrElse(false)).booleanValue()) {
            return Collections.emptyList();
        }
        if (context.hasConfig("resolveUntil") && !Try.run(() -> context.getContextValueByName(Object.class, context.getConfig("resolveUntil"))).isSuccess()) {
            return Collections.emptyList();
        }
        if (context.hasConfig("checkPermissions")) {
            for (String permission : REPatterns.SEMICOLON.split(context.getConfig("checkPermissions"))) {
                if (this.commandManager.getCommandPermissions().hasPermission(context.getIssuer(), permission)) continue;
                return Collections.emptyList();
            }
        }
        if (context.hasConfig("multiple")) {
            return StringFormatter.addonToCommaSeperated(context.getInput(), handler.getCompletions(context));
        }
        return handler.getCompletions(context);
    }

    public <T extends Enum<T>> Collection<String> suggestEnums(Class<T> enumClass) {
        return EnumSet.allOf(enumClass).stream().map(Enum::name).map(String::toLowerCase).toList();
    }

    private Collection<String> suggestAnchorNames(BukkitCommandCompletionContext context) {
        return this.anchorManager.getAnchors(context.getPlayer()).stream().map(MultiverseAnchor::getName).toList();
    }

    private Collection<String> suggestCommands(BukkitCommandCompletionContext context) {
        String rootCmdName = context.getConfig();
        if (rootCmdName == null) {
            return Collections.emptyList();
        }
        RootCommand rootCommand = ((Stream)this.commandManager.getRegisteredRootCommands().stream().unordered()).filter(c -> c.getCommandName().equals(rootCmdName)).findFirst().orElse(null);
        if (rootCommand == null) {
            return Collections.emptyList();
        }
        return rootCommand.getSubCommands().entries().stream().filter(entry -> this.checkPerms(context.getIssuer(), (RegisteredCommand)entry.getValue())).map(Map.Entry::getKey).filter(cmdName -> !cmdName.startsWith("__")).collect(Collectors.toList());
    }

    private boolean checkPerms(CommandIssuer issuer, RegisteredCommand<?> command) {
        return this.commandManager.hasPermission(issuer, command.getRequiredPermissions());
    }

    private Collection<String> suggestDestinations(BukkitCommandCompletionContext context) {
        return Try.of(() -> context.getContextValue(PlayerArrayValue.class)).map(PlayerArrayValue::value).recover(IllegalStateException.class, e -> context.getContextValue(Player[].class)).recover(IllegalStateException.class, e -> new Player[]{context.getContextValue(Player.class)}).map(players -> {
            if (((Player[])players).length == 0) {
                return Collections.emptyList();
            }
            if (context.hasConfig("othersOnly") && ((Player[])players).length == 1 && players[0].equals(context.getIssuer().getIssuer())) {
                return Collections.emptyList();
            }
            return this.suggestDestinationsWithPerms((CommandSender)context.getIssuer().getIssuer(), (Player[])players, context.getInput());
        }).getOrElse(Collections.emptyList());
    }

    private Collection<String> suggestDestinationsWithPerms(CommandSender teleporter, Player[] players, String deststring) {
        return this.destinationsProvider.suggestDestinations(teleporter, deststring).stream().filter(packet -> this.corePermissionsChecker.checkDestinationPacketPermission(teleporter, (List<Entity>)Arrays.asList(players), (DestinationSuggestionPacket)packet)).map(DestinationSuggestionPacket::parsableString).toList();
    }

    private Collection<String> suggestFlags(@NotNull BukkitCommandCompletionContext context) {
        String groupName = context.getConfig("groupName", "");
        return Try.of(() -> context.getContextValue(String[].class)).map(flags -> this.commandManager.getFlagsManager().suggest(groupName, (String[])flags)).getOrElse(Collections.emptyList());
    }

    private Collection<String> suggestGamerules() {
        return Arrays.stream(GameRule.values()).map(GameRule::getName).collect(Collectors.toList());
    }

    private Collection<String> suggestGamerulesValues(BukkitCommandCompletionContext context) {
        return Try.of(() -> context.getContextValue(GameRule.class)).mapTry(gamerule -> Option.of(DefaultSuggesterProvider.getDefaultSuggester(gamerule.getType())).map(s -> s.suggest(context.getInput())).getOrElse(Collections.emptyList())).getOrElse(Collections.emptyList());
    }

    private Collection<String> suggestGeneratorPlugins(BukkitCommandCompletionContext context) {
        return this.generatorProvider.getRegisteredGeneratorPlugins().stream().map(GeneratorPlugin::getPluginName).toList();
    }

    private Collection<String> suggestMVConfigValues(BukkitCommandCompletionContext context) {
        return Try.of(() -> context.getContextValue(String.class)).map(propertyName -> this.config.getStringPropertyHandle().getSuggestedPropertyValue((String)propertyName, context.getInput(), PropertyModifyAction.SET, context.getSender())).getOrElse(Collections.emptyList());
    }

    private Collection<String> suggestMVWorlds(BukkitCommandCompletionContext context) {
        String scope;
        switch (scope = context.getConfig("scope", "loaded")) {
            case "both": {
                return this.worldManager.getWorlds().stream().map(MultiverseWorld::getTabCompleteName).map(StringFormatter::quoteMultiWordString).toList();
            }
            case "loaded": {
                return this.worldManager.getLoadedWorlds().stream().map(MultiverseWorld::getTabCompleteName).map(StringFormatter::quoteMultiWordString).toList();
            }
            case "unloaded": {
                return this.worldManager.getUnloadedWorlds().stream().map(MultiverseWorld::getTabCompleteName).map(StringFormatter::quoteMultiWordString).toList();
            }
            case "potential": {
                return this.worldManager.getPotentialWorlds();
            }
        }
        CoreLogging.severe("Invalid MVWorld scope: " + scope, new Object[0]);
        return Collections.emptyList();
    }

    private Collection<String> suggestMVWorldPropsName(BukkitCommandCompletionContext context) {
        return Try.of(() -> {
            MultiverseWorld world = context.getContextValue(MultiverseWorldValue.class).value();
            PropertyModifyAction action = context.getContextValue(PropertyModifyAction.class);
            return world.getStringPropertyHandle().getModifiablePropertyNames(action);
        }).getOrElse(Collections.emptyList());
    }

    private Collection<String> suggestMVWorldPropsValue(BukkitCommandCompletionContext context) {
        return Try.of(() -> {
            MultiverseWorld world = context.getContextValue(MultiverseWorldValue.class).value();
            PropertyModifyAction action = context.getContextValue(PropertyModifyAction.class);
            String propertyName = context.getContextValue(String.class);
            return world.getStringPropertyHandle().getSuggestedPropertyValue(propertyName, context.getInput(), action, context.getSender());
        }).getOrElse(Collections.emptyList());
    }

    private Collection<String> suggestPlayersArray(BukkitCommandCompletionContext context) {
        CommandSender sender = context.getSender();
        Validate.notNull((Object)sender, (String)"Sender cannot be null", (Object[])new Object[0]);
        Player senderPlayer = sender instanceof Player ? (Player)sender : null;
        ArrayList<String> matchedPlayers = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            String name = player.getName();
            if (senderPlayer != null && !senderPlayer.canSee(player) || context.hasConfig("excludeSelf") && player.equals((Object)senderPlayer)) continue;
            matchedPlayers.add(name);
        }
        return StringFormatter.addonToCommaSeperated(context.getInput(), matchedPlayers);
    }

    private Collection<String> suggestSpawnCategoryPropsName(BukkitCommandCompletionContext context) {
        return Try.of(() -> {
            MultiverseWorld world = context.getContextValue(MultiverseWorld.class);
            SpawnCategory spawnCategory = context.getContextValue(SpawnCategory.class);
            PropertyModifyAction action = context.getContextValue(PropertyModifyAction.class);
            return world.getEntitySpawnConfig().getSpawnCategoryConfig(spawnCategory).getStringPropertyHandle().getModifiablePropertyNames(action);
        }).getOrElse(Collections.emptyList());
    }

    private Collection<String> suggestSpawnCategoryPropsValue(BukkitCommandCompletionContext context) {
        return Try.of(() -> {
            MultiverseWorld world = context.getContextValue(MultiverseWorld.class);
            SpawnCategory spawnCategory = context.getContextValue(SpawnCategory.class);
            PropertyModifyAction action = context.getContextValue(PropertyModifyAction.class);
            String propertyName = context.getContextValue(String.class);
            return world.getEntitySpawnConfig().getSpawnCategoryConfig(spawnCategory).getStringPropertyHandle().getSuggestedPropertyValue(propertyName, context.getInput(), action, context.getSender());
        }).getOrElse(Collections.emptyList());
    }
}

