/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.world.location;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;

@SerializableAs(value="MVSpawnLocation")
public class SpawnLocation
extends Location
implements ConfigurationSerializable {
    private Reference<World> worldRef;

    public SpawnLocation(double x, double y, double z) {
        super(null, x, y, z);
    }

    public SpawnLocation(double x, double y, double z, float yaw, float pitch) {
        super(null, x, y, z, yaw, pitch);
    }

    public SpawnLocation(Location loc) {
        this(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
    }

    public Location toBukkitLocation() {
        return new Location(this.getWorld(), this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    public World getWorld() {
        return this.worldRef != null ? this.worldRef.get() : null;
    }

    public void setWorld(World world) {
        this.worldRef = new WeakReference<World>(world);
    }

    @NotNull
    public Chunk getChunk() {
        World world;
        World world2 = world = this.worldRef != null ? this.worldRef.get() : null;
        if (world != null) {
            return world.getChunkAt((Location)this);
        }
        throw new IllegalStateException("World is null");
    }

    @NotNull
    public Block getBlock() {
        World world;
        World world2 = world = this.worldRef != null ? this.worldRef.get() : null;
        if (world != null) {
            return world.getBlockAt((Location)this);
        }
        throw new IllegalStateException("World is null");
    }

    @NotNull
    public SpawnLocation clone() {
        try {
            return (SpawnLocation)super.clone();
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", this.getX());
        map.put("y", this.getY());
        map.put("z", this.getZ());
        map.put("pitch", Float.valueOf(this.getPitch()));
        map.put("yaw", Float.valueOf(this.getYaw()));
        return map;
    }

    @NotNull
    public static SpawnLocation deserialize(Map<String, Object> args) {
        double x = ((Number)args.get("x")).doubleValue();
        double y = ((Number)args.get("y")).doubleValue();
        double z = ((Number)args.get("z")).doubleValue();
        float pitch = ((Number)args.get("pitch")).floatValue();
        float yaw = ((Number)args.get("yaw")).floatValue();
        return new SpawnLocation(x, y, z, yaw, pitch);
    }

    public String toString() {
        return "Location{world=" + String.valueOf(this.getWorld()) + ",x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + ",pitch=" + this.getPitch() + ",yaw=" + this.getYaw() + "}";
    }
}

