/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils.matcher;

import java.util.regex.Pattern;
import org.mvplugins.multiverse.core.utils.matcher.StringMatcher;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="5.2")
public class RegexStringMatcher
implements StringMatcher {
    private final String regexString;
    private final Pattern regexPattern;

    @ApiStatus.AvailableSince(value="5.2")
    public RegexStringMatcher(String regexString) {
        this.regexString = regexString;
        this.regexPattern = this.compileRegex(regexString);
    }

    private Pattern compileRegex(String regexString) {
        if (regexString.startsWith("r=")) {
            regexString = regexString.substring(2);
        }
        return Pattern.compile(regexString);
    }

    @Override
    public boolean matches(String value) {
        return this.regexPattern.matcher(value).matches();
    }
}

