/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.utils;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;

public final class StringFormatter {
    private StringFormatter() {
    }

    @NotNull
    public static String joinAnd(List<String> list) {
        return StringFormatter.join(list, ", ", " and ");
    }

    @NotNull
    public static String join(Collection list, String separator) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        return list.stream().map(String::valueOf).collect(Collectors.joining(separator)).toString();
    }

    @NotNull
    public static String join(List<String> list, String separator, String lastSeparator) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder authors = new StringBuilder();
        authors.append(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            if (i == list.size() - 1) {
                authors.append(lastSeparator).append(list.get(i));
                continue;
            }
            authors.append(separator).append(list.get(i));
        }
        return authors.toString();
    }

    public static Collection<String> addonToCommaSeperated(@Nullable String input, @NotNull Collection<String> addons) {
        if (Strings.isNullOrEmpty((String)input)) {
            return addons;
        }
        int lastComma = input.lastIndexOf(44);
        String previousInputs = input.substring(0, lastComma + 1);
        HashSet inputSet = Sets.newHashSet((Object[])REPatterns.COMMA.split(input));
        return addons.stream().filter(suggestion -> !inputSet.contains(suggestion)).map(suggestion -> previousInputs + suggestion).toList();
    }

    public static Collection<String> parseQuotesInArgs(String[] args) {
        ArrayList<String> result = new ArrayList<String>(args.length);
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        int quoteStartIndex = -1;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!inQuotes && arg.startsWith("\"") && !arg.endsWith("\"")) {
                inQuotes = true;
                quoteStartIndex = i;
                current.append(arg.substring(1));
                continue;
            }
            if (inQuotes && arg.endsWith("\"")) {
                current.append(" ").append(arg, 0, arg.length() - 1);
                result.add(current.toString());
                current.setLength(0);
                inQuotes = false;
                quoteStartIndex = -1;
                continue;
            }
            if (inQuotes) {
                current.append(" ").append(arg);
                continue;
            }
            if (arg.startsWith("\"") && arg.endsWith("\"") && arg.length() > 1) {
                result.add(arg.substring(1, arg.length() - 1));
                continue;
            }
            result.add(arg);
        }
        if (inQuotes) {
            result.addAll(Arrays.asList(args).subList(quoteStartIndex, args.length));
        }
        return result;
    }

    public static String quoteMultiWordString(String input) {
        return input.contains(" ") ? "\"" + input + "\"" : input;
    }
}

