/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.listeners;

import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.listeners.CoreListener;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
final class MVEntityListener
implements CoreListener {
    private final WorldManager worldManager;

    @Inject
    MVEntityListener(@NotNull WorldManager worldManager) {
        this.worldManager = worldManager;
    }

    @EventMethod
    public void foodLevelChange(FoodLevelChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        HumanEntity humanEntity = event.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.worldManager.getLoadedWorld(player.getWorld()).peek(world -> {
            if (!world.isHunger() && event.getFoodLevel() < player.getFoodLevel()) {
                event.setCancelled(true);
            }
        });
    }

    @EventMethod
    public void entityRegainHealth(EntityRegainHealthEvent event) {
        if (event.isCancelled() || event.getRegainReason() != EntityRegainHealthEvent.RegainReason.REGEN) {
            return;
        }
        this.worldManager.getLoadedWorld(event.getEntity().getWorld()).peek(world -> {
            if (!world.getAutoHeal()) {
                event.setCancelled(true);
            }
        });
    }

    @EventMethod
    public void creatureSpawn(CreatureSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM || event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.COMMAND || event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.BREEDING || event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
            return;
        }
        this.worldManager.getLoadedWorld(event.getEntity().getWorld()).peek(world -> {
            if (!world.getEntitySpawnConfig().shouldAllowSpawn((Entity)event.getEntity())) {
                CoreLogging.finest("Cancelling Creature Spawn Event for: " + String.valueOf(event.getEntity()), new Object[0]);
                event.setCancelled(true);
            }
        });
    }

    @EventMethod
    public void entitySpawn(EntitySpawnEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            return;
        }
        this.worldManager.getLoadedWorld(event.getEntity().getWorld()).peek(world -> {
            if (!world.getEntitySpawnConfig().shouldAllowSpawn(event.getEntity())) {
                CoreLogging.finest("Cancelling Entity Spawn Event for: " + String.valueOf(event.getEntity()), new Object[0]);
                event.setCancelled(true);
            }
        });
    }
}

