/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.node;

import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.util.Strings;
import org.bukkit.command.CommandSender;
import org.mvplugins.multiverse.core.config.node.ConfigHeaderNode;
import org.mvplugins.multiverse.core.config.node.ValueNode;
import org.mvplugins.multiverse.core.config.node.functions.DefaultStringParserProvider;
import org.mvplugins.multiverse.core.config.node.functions.DefaultSuggesterProvider;
import org.mvplugins.multiverse.core.config.node.functions.NodeStringParser;
import org.mvplugins.multiverse.core.config.node.functions.NodeSuggester;
import org.mvplugins.multiverse.core.config.node.functions.SenderNodeStringParser;
import org.mvplugins.multiverse.core.config.node.functions.SenderNodeSuggester;
import org.mvplugins.multiverse.core.config.node.serializer.DefaultSerializerProvider;
import org.mvplugins.multiverse.core.config.node.serializer.NodeSerializer;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

public class ConfigNode<T>
extends ConfigHeaderNode
implements ValueNode<T> {
    @Nullable
    protected final String name;
    @NotNull
    protected final Class<T> type;
    @NotNull
    protected final String[] aliases;
    @Nullable
    protected Supplier<T> defaultValue;
    @Nullable
    protected NodeSuggester suggester;
    @Nullable
    protected NodeStringParser<T> stringParser;
    @Nullable
    protected NodeSerializer<T> serializer;
    @Nullable
    protected Function<T, Try<Void>> validator;
    @Nullable
    protected BiConsumer<T, T> onSetValue;

    @NotNull
    public static <T> Builder<T, ? extends Builder<T, ?>> builder(@NotNull String path, @NotNull Class<T> type) {
        return new Builder(path, type);
    }

    protected ConfigNode(@NotNull String path, @NotNull String[] comments, @Nullable String name, @NotNull Class<T> type, @NotNull String[] aliases, @Nullable Supplier<T> defaultValue, @Nullable NodeSuggester suggester, @Nullable NodeStringParser<T> stringParser, @Nullable NodeSerializer<T> serializer, @Nullable Function<T, Try<Void>> validator, @Nullable BiConsumer<T, T> onSetValue) {
        super(path, comments);
        this.name = name;
        this.type = type;
        this.aliases = aliases;
        this.defaultValue = defaultValue;
        this.suggester = suggester != null ? suggester : DefaultSuggesterProvider.getDefaultSuggester(type);
        this.stringParser = stringParser != null ? stringParser : DefaultStringParserProvider.getDefaultStringParser(type);
        this.serializer = serializer != null ? serializer : DefaultSerializerProvider.getDefaultSerializer(type);
        this.validator = validator;
        this.onSetValue = onSetValue;
    }

    @Override
    @NotNull
    public Option<String> getName() {
        return Option.of(this.name);
    }

    @Override
    @NotNull
    public Class<T> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public T getDefaultValue() {
        if (this.defaultValue != null) {
            return this.defaultValue.get();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<String> suggest(@Nullable String input) {
        if (this.suggester != null) {
            return this.suggester.suggest(input);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<String> suggest(@NotNull CommandSender sender, @Nullable String input) {
        NodeSuggester nodeSuggester;
        if (this.suggester != null && (nodeSuggester = this.suggester) instanceof SenderNodeSuggester) {
            SenderNodeSuggester senderSuggester = (SenderNodeSuggester)nodeSuggester;
            return senderSuggester.suggest(sender, input);
        }
        return this.suggest(input);
    }

    @Override
    @NotNull
    public Try<T> parseFromString(@Nullable String input) {
        if (this.stringParser != null) {
            return this.stringParser.parse(input, this.type);
        }
        return Try.failure(new UnsupportedOperationException("No string parser for type " + this.type.getName()));
    }

    @Override
    @NotNull
    public Try<T> parseFromString(@NotNull CommandSender sender, @Nullable String input) {
        NodeStringParser<T> nodeStringParser;
        if (this.stringParser != null && (nodeStringParser = this.stringParser) instanceof SenderNodeStringParser) {
            SenderNodeStringParser senderStringParser = (SenderNodeStringParser)nodeStringParser;
            return senderStringParser.parse(sender, input, this.type);
        }
        return this.parseFromString(input);
    }

    @Override
    @Nullable
    public NodeSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    public Try<Void> validate(@Nullable T value) {
        if (this.validator != null) {
            return this.validator.apply(value);
        }
        return Try.success(null);
    }

    @Override
    public void onSetValue(@Nullable T oldValue, @Nullable T newValue) {
        if (this.onSetValue != null) {
            this.onSetValue.accept(oldValue, newValue);
        }
    }

    public static class Builder<T, B extends Builder<T, B>>
    extends ConfigHeaderNode.Builder<B> {
        @Nullable
        protected String name;
        @NotNull
        protected final Class<T> type;
        @NotNull
        protected String[] aliases = Strings.EMPTY_ARRAY;
        @Nullable
        protected Supplier<T> defaultValue;
        @Nullable
        protected NodeSuggester suggester;
        @Nullable
        protected NodeStringParser<T> stringParser;
        @Nullable
        protected NodeSerializer<T> serializer;
        @Nullable
        protected Function<T, Try<Void>> validator;
        @Nullable
        protected BiConsumer<T, T> onSetValue;

        protected Builder(@NotNull String path, @NotNull Class<T> type) {
            super(path);
            this.name = path;
            this.type = type;
        }

        @NotNull
        public String path() {
            return this.path;
        }

        @NotNull
        public B defaultValue(@NotNull T defaultValue) {
            this.defaultValue = () -> defaultValue;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B defaultValue(@NotNull Supplier<T> defaultValue) {
            this.defaultValue = defaultValue;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B name(@Nullable String name) {
            this.name = name;
            return (B)((Builder)this.self());
        }

        @Nullable
        public String name() {
            return this.name;
        }

        @NotNull
        public B hidden() {
            return this.name(null);
        }

        @ApiStatus.AvailableSince(value="5.1")
        @NotNull
        public B aliases(String ... aliases) {
            this.aliases = aliases;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B suggester(@NotNull NodeSuggester suggester) {
            this.suggester = suggester;
            return (B)((Builder)this.self());
        }

        @ApiStatus.AvailableSince(value="5.1")
        @NotNull
        public B suggester(@NotNull SenderNodeSuggester suggester) {
            this.suggester = suggester;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B stringParser(@NotNull NodeStringParser<T> stringParser) {
            this.stringParser = stringParser;
            return (B)((Builder)this.self());
        }

        @ApiStatus.AvailableSince(value="5.1")
        @NotNull
        public B stringParser(@NotNull SenderNodeStringParser<T> stringParser) {
            this.stringParser = stringParser;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B serializer(@NotNull NodeSerializer<T> serializer) {
            this.serializer = serializer;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B validator(@NotNull Function<T, Try<Void>> validator) {
            this.validator = validator;
            return (B)((Builder)this.self());
        }

        @NotNull
        public B onSetValue(@NotNull BiConsumer<T, T> onSetValue) {
            this.onSetValue = this.onSetValue == null ? onSetValue : this.onSetValue.andThen(onSetValue);
            return (B)((Builder)this.self());
        }

        @Override
        @NotNull
        public ConfigNode<T> build() {
            return new ConfigNode<T>(this.path, this.comments.toArray(new String[0]), this.name, this.type, this.aliases, this.defaultValue, this.suggester, this.stringParser, this.serializer, this.validator, this.onSetValue);
        }
    }
}

