/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.migration.action;

import java.util.function.Supplier;
import org.bukkit.configuration.ConfigurationSection;
import org.mvplugins.multiverse.core.config.migration.action.MigratorAction;
import org.mvplugins.multiverse.core.utils.CoreLogging;

public final class SetMigratorAction<T>
implements MigratorAction {
    private final String path;
    private final Supplier<T> value;

    public static <T> SetMigratorAction<T> of(String path, T value) {
        return new SetMigratorAction<Object>(path, () -> value);
    }

    public static <T> SetMigratorAction<T> of(String path, Supplier<T> value) {
        return new SetMigratorAction<T>(path, value);
    }

    SetMigratorAction(String path, Supplier<T> value) {
        this.path = path;
        this.value = value;
    }

    @Override
    public void migrate(ConfigurationSection config) {
        config.set(this.path, this.value.get());
        CoreLogging.config("Set %s to %s", this.path, this.value.get());
    }
}

