/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.config.handle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.mvplugins.multiverse.core.config.migration.ConfigMigrator;
import org.mvplugins.multiverse.core.config.node.ListValueNode;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.core.config.node.ValueNode;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;

public abstract class BaseConfigurationHandle<C extends ConfigurationSection> {
    @Nullable
    protected final Logger logger;
    @NotNull
    protected final NodeGroup nodes;
    @Nullable
    protected final ConfigMigrator migrator;
    @NotNull
    protected final Map<ValueNode, Object> nodeValueMap;
    protected C config;

    protected BaseConfigurationHandle(@Nullable Logger logger, @NotNull NodeGroup nodes, @Nullable ConfigMigrator migrator) {
        this.logger = logger;
        this.nodes = nodes;
        this.migrator = migrator;
        this.nodeValueMap = new HashMap<ValueNode, Object>(nodes.size());
    }

    public Try<Void> load() {
        return Try.run(() -> {
            this.migrateConfig();
            this.setUpNodes();
        }).onFailure(e -> CoreLogging.severe("Failed to load configuration: %s", e.getMessage()));
    }

    protected void migrateConfig() {
        if (this.migrator != null) {
            this.migrator.migrate((ConfigurationSection)this.config);
        }
    }

    protected void setUpNodes() {
        this.nodeValueMap.clear();
        if (this.nodes.isEmpty()) {
            return;
        }
        this.nodes.forEach(node -> {
            if (node instanceof ValueNode) {
                ValueNode valueNode = (ValueNode)node;
                Object value = this.deserializeNodeFromConfig(valueNode);
                this.nodeValueMap.put(valueNode, value);
            }
        });
        this.nodeValueMap.forEach((valueNode, value) -> valueNode.onSetValue(value, value));
    }

    protected <T> T deserializeNodeFromConfig(ValueNode<T> node) {
        if (node.getSerializer() == null) {
            return (T)Option.of(this.config.getObject(node.getPath(), node.getType())).getOrElse(node::getDefaultValue);
        }
        return (T)Try.of(() -> {
            Object value = this.config.get(node.getPath());
            if (value == null) {
                return node.getDefaultValue();
            }
            return node.getSerializer().deserialize(value, node.getType());
        }).flatMap(value -> node.validate(value).map(ignore -> value)).onFailure(e -> CoreLogging.warning("Failed to deserialize node %s: %s", node.getPath(), e.getMessage())).getOrElse(node::getDefaultValue);
    }

    public Try<Void> save() {
        return Try.run(() -> this.nodes.forEach(node -> {
            if (!(node instanceof ValueNode)) {
                return;
            }
            ValueNode valueNode = (ValueNode)node;
            this.serializeNodeToConfig(valueNode);
        }));
    }

    protected void serializeNodeToConfig(ValueNode node) {
        Object value = this.nodeValueMap.get(node);
        if (value == null) {
            value = node.getDefaultValue();
        }
        if (node.getSerializer() != null) {
            Object serialized = node.getSerializer().serialize(value, node.getType());
            this.config.set(node.getPath(), serialized);
        } else {
            this.config.set(node.getPath(), value);
        }
    }

    public boolean isLoaded() {
        return !this.nodeValueMap.isEmpty();
    }

    public <T> T get(@NotNull ValueNode<T> node) {
        return (T)this.nodeValueMap.get(node);
    }

    public <T> Try<Void> set(@NotNull ValueNode<T> node, T value) {
        return node.validate(value).map(ignore -> {
            Object oldValue = this.get(node);
            this.nodeValueMap.put(node, value);
            node.onSetValue(oldValue, this.get(node));
            return null;
        });
    }

    public <I> Try<Void> add(@NotNull ListValueNode<I> node, I itemValue) {
        return node.validateItem(itemValue).map(ignore -> {
            List list = (List)this.get(node);
            list.add(itemValue);
            node.onSetItemValue(null, itemValue);
            return null;
        });
    }

    public <I> Try<Void> remove(@NotNull ListValueNode<I> node, I itemValue) {
        return node.validateItem(itemValue).map(ignore -> {
            List list = (List)this.get(node);
            if (!list.remove(itemValue)) {
                throw new IllegalArgumentException("Cannot remove item as it is already not in the list!");
            }
            node.onSetItemValue(itemValue, null);
            return null;
        });
    }

    public <T> Try<Void> reset(@NotNull ValueNode<T> node) {
        return this.set(node, node.getDefaultValue());
    }

    public C getConfig() {
        return this.config;
    }

    @NotNull
    NodeGroup getNodes() {
        return this.nodes;
    }

    public static abstract class Builder<C extends ConfigurationSection, B extends Builder<C, B>> {
        @NotNull
        protected final NodeGroup nodes;
        @Nullable
        protected Logger logger;
        @Nullable
        protected ConfigMigrator migrator;

        protected Builder(@NotNull NodeGroup nodes) {
            this.nodes = nodes;
        }

        public B logger(@Nullable Logger logger) {
            this.logger = logger;
            return this.self();
        }

        public B logger(Plugin plugin) {
            this.logger = plugin.getLogger();
            return this.self();
        }

        public B migrator(@Nullable ConfigMigrator migrator) {
            this.migrator = migrator;
            return this.self();
        }

        @NotNull
        public abstract BaseConfigurationHandle<C> build();

        protected B self() {
            return (B)this;
        }
    }
}

