/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import java.util.List;
import org.bukkit.ChatColor;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.flags.PageFilterFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.display.ContentDisplay;
import org.mvplugins.multiverse.core.display.filters.DefaultContentFilter;
import org.mvplugins.multiverse.core.display.handlers.PagedSendHandler;
import org.mvplugins.multiverse.core.display.handlers.SendHandler;
import org.mvplugins.multiverse.core.display.parsers.ListContentProvider;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.core.world.generators.GeneratorPlugin;
import org.mvplugins.multiverse.core.world.generators.GeneratorProvider;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class GeneratorsCommand
extends CoreCommand {
    private final GeneratorProvider generatorProvider;
    private final PageFilterFlags flags;

    @Inject
    GeneratorsCommand(@NotNull GeneratorProvider generatorProvider, @NotNull PageFilterFlags flags) {
        this.generatorProvider = generatorProvider;
        this.flags = flags;
    }

    @Subcommand(value="generators list")
    @CommandPermission(value="multiverse.core.generator")
    @CommandCompletion(value="@flags:groupName=pagefilter")
    @Syntax(value="[--page <page>] [--filter <filter>]")
    @Description(value="{@@mv-core.generators.description}")
    void onGeneratorsListCommand(@NotNull MVCommandIssuer issuer, @Optional @Syntax(value="[--page <page>] [--filter <filter>]") @Description(value="{@@mv-core.generators.description.flags}") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        List generators = (List)this.generatorProvider.suggestGeneratorString("");
        if (generators.isEmpty()) {
            issuer.sendMessage(MVCorei18n.GENERATORS_EMPTY, new MessageReplacement[0]);
            return;
        }
        ContentDisplay.create().addContent(ListContentProvider.forContent(generators)).withSendHandler((SendHandler)((PagedSendHandler)PagedSendHandler.create().withHeader("%s====[ Multiverse Generator List ]====", ChatColor.AQUA)).doPagination(true).withTargetPage(parsedFlags.flagValue(this.flags.page, 1)).withFilter(parsedFlags.flagValue(this.flags.filter, DefaultContentFilter.get()))).send(issuer);
    }

    @Subcommand(value="generators info")
    @CommandPermission(value="multiverse.core.generator")
    @CommandCompletion(value="@generatorplugins")
    @Syntax(value="<generator>")
    void onGeneratorsInfoCommand(@NotNull MVCommandIssuer issuer, @Syntax(value="<generator>") GeneratorPlugin generatorPlugin) {
        issuer.sendMessage(String.valueOf(ChatColor.RESET) + "Generator Plugin: " + generatorPlugin.getPluginName());
        issuer.sendMessage(String.valueOf(ChatColor.RESET) + "Example usages: ");
        issuer.sendMessage(String.valueOf(ChatColor.RESET) + StringFormatter.join(generatorPlugin.getExampleUsages(), "\n"));
        issuer.sendMessage(String.valueOf(ChatColor.RESET) + "Link to more info: " + generatorPlugin.getInfoLink());
    }

    @Service
    private static final class LegacyAlias
    extends GeneratorsCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull GeneratorProvider generatorProvider, @NotNull PageFilterFlags flags) {
            super(generatorProvider, flags);
        }

        @Override
        @CommandAlias(value="mvgenerators|mvgens")
        void onGeneratorsListCommand(@NotNull MVCommandIssuer issuer, String[] flags) {
            super.onGeneratorsListCommand(issuer, flags);
        }
    }
}

