/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.core.commands;

import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.FlagBuilder;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.commands.CoreCommand;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.CoreLogging;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.options.CloneWorldOptions;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jvnet.hk2.annotations.Service;

@Service
class CloneCommand
extends CoreCommand {
    private final WorldManager worldManager;
    private final Flags flags;

    @Inject
    CloneCommand(@NotNull WorldManager worldManager, @NotNull Flags flags) {
        this.worldManager = worldManager;
        this.flags = flags;
    }

    @Subcommand(value="clone")
    @CommandPermission(value="multiverse.core.clone")
    @CommandCompletion(value="@mvworlds:scope=loaded @empty @flags:groupName=mvclone")
    @Syntax(value="<world> <new-world-name> [--reset-world-config --reset-gamerules --reset-world-border]")
    @Description(value="{@@mv-core.clone.description}")
    void onCloneCommand(MVCommandIssuer issuer, @Syntax(value="<world>") @Description(value="{@@mv-core.clone.world.description}") LoadedMultiverseWorld world, @Syntax(value="<new-world-name>") @Description(value="{@@mv-core.clone.newWorld.description}") String newWorldName, @Optional @Syntax(value="[--reset-world-config --reset-gamerules --reset-world-border]") @Description(value="{@@mv-core.regen.other.description}") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        issuer.sendInfo((MessageKeyProvider)MVCorei18n.CLONE_CLONING, MessageReplacement.Replace.WORLD.with(world.getName()), MessageReplacement.replace("{newworld}").with(newWorldName));
        CloneWorldOptions cloneWorldOptions = CloneWorldOptions.fromTo(world, newWorldName).keepWorldConfig(!parsedFlags.hasFlag(this.flags.resetWorldConfig)).keepGameRule(!parsedFlags.hasFlag(this.flags.resetGamerules)).keepWorldBorder(!parsedFlags.hasFlag(this.flags.resetWorldBorder)).saveBukkitWorld(!parsedFlags.hasFlag(this.flags.noSave));
        this.worldManager.cloneWorld(cloneWorldOptions).onSuccess(newWorld -> {
            CoreLogging.fine("World clone success: " + String.valueOf(newWorld), new Object[0]);
            issuer.sendInfo((MessageKeyProvider)MVCorei18n.CLONE_SUCCESS, MessageReplacement.Replace.WORLD.with(newWorld.getName()));
        }).onFailure(failure -> {
            CoreLogging.fine("World clone failure: " + String.valueOf(failure), new Object[0]);
            issuer.sendError(failure.getFailureMessage());
        });
    }

    @Service
    private static final class Flags
    extends FlagBuilder {
        private static final String NAME = "mvclone";
        private final CommandFlag resetWorldConfig = this.flag(((CommandFlag.Builder)CommandFlag.builder("--reset-world-config").addAlias("-wc")).build());
        private final CommandFlag resetGamerules = this.flag(((CommandFlag.Builder)CommandFlag.builder("--reset-gamerules").addAlias("-gm")).build());
        private final CommandFlag resetWorldBorder = this.flag(((CommandFlag.Builder)CommandFlag.builder("--reset-world-border").addAlias("-wb")).build());
        private final CommandFlag noSave = this.flag(((CommandFlag.Builder)CommandFlag.builder("--no-save").addAlias("-s")).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager) {
            super(NAME, flagsManager);
        }
    }

    @Service
    private static final class LegacyAlias
    extends CloneCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(@NotNull WorldManager worldManager, @NotNull Flags flags) {
            super(worldManager, flags);
        }

        @Override
        @CommandAlias(value="mvcl|mvclone")
        void onCloneCommand(MVCommandIssuer issuer, LoadedMultiverseWorld world, String newWorldName, String[] flags) {
            super.onCloneCommand(issuer, world, newWorldName, flags);
        }
    }
}

