/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.HTTP3Session;
import org.eclipse.jetty.http3.HTTP3StreamConnection;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTP3Stream
implements Stream,
CyclicTimeouts.Expirable,
Attachable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3Stream.class);
    private final AutoLock lock = new AutoLock();
    private final AtomicReference<Stream.Data> dataRef = new AtomicReference();
    private final HTTP3Session session;
    private final QuicStreamEndPoint endPoint;
    private final boolean local;
    private CloseState closeState = CloseState.NOT_CLOSED;
    private FrameState frameState = FrameState.INITIAL;
    private long idleTimeout;
    private long expireNanoTime = Long.MAX_VALUE;
    private Object attachment;
    private boolean dataDemand;
    private boolean dataStalled;
    private boolean dataLast;
    private boolean dataAvailable;

    public HTTP3Stream(HTTP3Session session, QuicStreamEndPoint endPoint, boolean local) {
        this.session = session;
        this.endPoint = endPoint;
        this.local = local;
    }

    public QuicStreamEndPoint getEndPoint() {
        return this.endPoint;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public long getId() {
        return this.endPoint.getStreamId();
    }

    @Override
    public HTTP3Session getSession() {
        return this.session;
    }

    public boolean isLocal() {
        return this.local;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.notIdle();
        this.session.scheduleIdleTimeout(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("set idle timeout {} ms for {}", (Object)idleTimeout, (Object)this);
        }
    }

    public long getExpireNanoTime() {
        return this.expireNanoTime;
    }

    protected void notIdle() {
        long idleTimeout = this.getIdleTimeout();
        if (idleTimeout > 0L) {
            this.expireNanoTime = NanoTime.now() + TimeUnit.MILLISECONDS.toNanos(idleTimeout);
        }
    }

    void onIdleTimeout(TimeoutException timeout, Promise<Boolean> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout {} ms expired on {}", (Object)this.getIdleTimeout(), (Object)this);
        }
        this.notifyIdleTimeout(timeout, (Promise<Boolean>)Promise.from(timedOut -> {
            if (timedOut.booleanValue()) {
                this.endPoint.close(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), (Throwable)timeout);
            } else {
                this.notIdle();
            }
            promise.succeeded(timedOut);
        }, arg_0 -> promise.failed(arg_0)));
    }

    @Override
    public CompletableFuture<Stream> data(DataFrame frame) {
        return this.write(frame);
    }

    protected CompletableFuture<Stream> write(Frame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} on {}", (Object)frame, (Object)this);
        }
        return this.writeFrame(frame).whenComplete((s, x) -> {
            if (x == null) {
                this.updateClose(Frame.isLast(frame), true);
            } else {
                this.session.removeStream(this, (Throwable)x);
            }
        });
    }

    @Override
    public Stream.Data readData() {
        try {
            Stream.Data data;
            if (LOG.isDebugEnabled()) {
                LOG.debug("reading data on {}", (Object)this);
            }
            if (this.isLast()) {
                data = Stream.Data.EOF;
            } else {
                data = this.read();
                if (data == null) {
                    HTTP3StreamConnection connection = (HTTP3StreamConnection)this.endPoint.getConnection();
                    connection.receive();
                    data = this.read();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("read {} on {}", (Object)data, (Object)this);
            }
            return data;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not read {}", (Object)this, (Object)x);
            }
            this.reset(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), x);
            throw x;
        }
    }

    private Stream.Data read() {
        Stream.Data data = this.dataRef.getAndSet(null);
        try (AutoLock ignored = this.lock.lock();){
            if (data != null) {
                this.dataLast = data.isLast();
            } else {
                this.dataAvailable = false;
            }
        }
        if (data != null) {
            this.updateClose(data.isLast(), false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("reading available data {} on {}", (Object)data, (Object)this);
        }
        return data;
    }

    @Override
    public void demand() {
        boolean hasData;
        boolean process = false;
        try (AutoLock ignored = this.lock.lock();){
            this.dataDemand = true;
            hasData = this.dataAvailable;
            if (this.dataStalled && hasData || this.dataLast) {
                this.dataStalled = false;
                process = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("demand, wasStalled={} dataAvailable={} on {}", new Object[]{process, hasData, this});
        }
        if (process) {
            this.processData();
        } else if (!hasData) {
            HTTP3StreamConnection connection = (HTTP3StreamConnection)this.endPoint.getConnection();
            connection.fillInterested();
        }
    }

    private void processData() {
        while (true) {
            boolean notify = true;
            try (AutoLock ignored = this.lock.lock();){
                if (LOG.isDebugEnabled()) {
                    LOG.debug("processing demand={}, last={} on {}", new Object[]{this.dataDemand, this.dataLast, this});
                }
                if (this.dataDemand) {
                    if (!this.dataAvailable) {
                        notify = false;
                    } else {
                        this.dataDemand = false;
                    }
                } else {
                    this.dataStalled = true;
                    notify = false;
                }
            }
            if (!notify) break;
            this.onDataAvailable();
        }
    }

    @Override
    public CompletableFuture<Stream> trailer(HeadersFrame frame) {
        if (!frame.isLast()) {
            throw new IllegalArgumentException("invalid trailer frame: property 'last' must be true");
        }
        return this.write(frame);
    }

    public boolean hasDemand() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.dataDemand;
            return bl;
        }
    }

    private boolean isStalled() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.dataStalled;
            return bl;
        }
    }

    private boolean isLast() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.dataLast;
            return bl;
        }
    }

    public void onHeaders(HeadersFrame frame) {
        this.notIdle();
        try (AutoLock ignored = this.lock.lock();){
            this.dataLast = frame.isLast();
            this.dataAvailable = true;
        }
    }

    protected boolean hasDemandOrStall() {
        try (AutoLock ignored = this.lock.lock();){
            this.dataStalled = !this.dataDemand;
            boolean bl = this.dataDemand;
            return bl;
        }
    }

    public void onData(DataFrame ignored) {
        if (this.validateAndUpdate(EnumSet.of(FrameState.HEADER, FrameState.DATA), FrameState.DATA)) {
            this.notIdle();
        }
    }

    private void onDataAvailable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifying data available on {}", (Object)this);
        }
        this.notifyDataAvailable();
    }

    public void onData(Stream.Data data) {
        boolean process;
        data.retain();
        if (!this.dataRef.compareAndSet(null, data)) {
            throw new IllegalStateException();
        }
        try (AutoLock ignored = this.lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onData demand={}, last={} {} on {}", new Object[]{this.dataDemand, this.dataLast, data, this});
            }
            this.dataAvailable = true;
            process = this.dataDemand;
        }
        if (process) {
            this.processData();
        }
    }

    protected abstract void notifyDataAvailable();

    public void onTrailer(HeadersFrame frame) {
        if (this.validateAndUpdate(EnumSet.of(FrameState.HEADER, FrameState.DATA), FrameState.TRAILER)) {
            this.notIdle();
            this.notifyTrailer(frame);
            this.updateClose(frame.isLast(), false);
        }
    }

    protected abstract void notifyTrailer(HeadersFrame var1);

    protected abstract void notifyIdleTimeout(TimeoutException var1, Promise<Boolean> var2);

    public void onFailure(long error, Throwable failure) {
        this.notifyFailure(error, failure);
        this.session.removeStream(this, failure);
    }

    public abstract void notifyFailure(long var1, Throwable var3);

    protected boolean validateAndUpdate(EnumSet<FrameState> allowed, FrameState target) {
        if (allowed.contains((Object)this.frameState)) {
            this.frameState = target;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("invalid frame sequence, current={}, allowed={}, next={}", new Object[]{this.frameState, allowed, target});
        }
        if (this.frameState == FrameState.FAILED) {
            return false;
        }
        this.frameState = FrameState.FAILED;
        this.session.onSessionFailure(HTTP3ErrorCode.FRAME_UNEXPECTED_ERROR.code(), "invalid_frame_sequence", new IllegalStateException("invalid frame sequence"));
        return false;
    }

    public Promise.Completable<Stream> writeFrame(Frame frame) {
        this.notIdle();
        return Promise.Completable.with(p -> this.session.writeMessageFrame(this.endPoint.getStreamId(), frame, Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, () -> p.succeeded((Object)this), arg_0 -> ((Promise)p).failed(arg_0))));
    }

    public boolean isClosed() {
        return this.closeState == CloseState.CLOSED;
    }

    public void updateClose(boolean update, boolean local) {
        if (update) {
            switch (this.closeState.ordinal()) {
                case 0: {
                    this.closeState = local ? CloseState.LOCALLY_CLOSED : CloseState.REMOTELY_CLOSED;
                    break;
                }
                case 1: {
                    if (local) break;
                    this.closeState = CloseState.CLOSED;
                    this.session.removeStream(this, null);
                    break;
                }
                case 2: {
                    if (!local) break;
                    this.closeState = CloseState.CLOSED;
                    this.session.removeStream(this, null);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public void reset(long error, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("resetting {} with error 0x{} {}", new Object[]{this, Long.toHexString(error), failure.toString()});
        }
        this.closeState = CloseState.CLOSED;
        this.session.removeStream(this, failure);
        this.endPoint.close(error, failure);
    }

    public String toString() {
        return String.format("%s@%x#%d[demand=%b,stalled=%b,last=%b,idle=%d,session=%s]", this.getClass().getSimpleName(), this.hashCode(), this.getId(), this.hasDemand(), this.isStalled(), this.isLast(), NanoTime.millisSince((long)this.expireNanoTime), this.getSession());
    }

    private static enum CloseState {
        NOT_CLOSED,
        LOCALLY_CLOSED,
        REMOTELY_CLOSED,
        CLOSED;

    }

    protected static enum FrameState {
        INITIAL,
        INFORMATIONAL,
        HEADER,
        DATA,
        TRAILER,
        FAILED;

    }
}

