/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.proxy;

import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.fcgi.client.transport.HttpClientTransportOverFCGI;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.proxy.ProxyHandler;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastCGIProxyHandler
extends ProxyHandler.Reverse {
    private static final Logger LOG = LoggerFactory.getLogger(FastCGIProxyHandler.class);
    private static final String REMOTE_ADDR_ATTRIBUTE = FastCGIProxyHandler.class.getName() + ".remoteAddr";
    private static final String REMOTE_PORT_ATTRIBUTE = FastCGIProxyHandler.class.getName() + ".remotePort";
    private static final String SERVER_NAME_ATTRIBUTE = FastCGIProxyHandler.class.getName() + ".serverName";
    private static final String SERVER_ADDR_ATTRIBUTE = FastCGIProxyHandler.class.getName() + ".serverAddr";
    private static final String SERVER_PORT_ATTRIBUTE = FastCGIProxyHandler.class.getName() + ".serverPort";
    private static final String SCHEME_ATTRIBUTE = FastCGIProxyHandler.class.getName() + ".scheme";
    private static final String REQUEST_URI_ATTRIBUTE = FastCGIProxyHandler.class.getName() + ".requestURI";
    private static final String REQUEST_QUERY_ATTRIBUTE = FastCGIProxyHandler.class.getName() + ".requestQuery";
    private final String scriptRoot;
    private Pattern scriptPattern;
    private String originalPathAttribute;
    private String originalQueryAttribute;
    private boolean fcgiSecure;
    private Set<String> fcgiEnvNames;
    private Path unixDomainPath;

    public FastCGIProxyHandler(String uriPattern, String uriReplacement, String scriptRoot) {
        super(uriPattern, uriReplacement);
        this.scriptRoot = Objects.requireNonNull(scriptRoot);
    }

    public FastCGIProxyHandler(Function<org.eclipse.jetty.server.Request, HttpURI> httpURIRewriter, String scriptRoot) {
        super(httpURIRewriter);
        this.scriptRoot = Objects.requireNonNull(scriptRoot);
    }

    public String getScriptRoot() {
        return this.scriptRoot;
    }

    public Pattern getScriptPattern() {
        return this.scriptPattern;
    }

    public void setScriptPattern(Pattern scriptPattern) {
        this.scriptPattern = scriptPattern;
    }

    public String getOriginalPathAttribute() {
        return this.originalPathAttribute;
    }

    public void setOriginalPathAttribute(String originalPathAttribute) {
        this.originalPathAttribute = originalPathAttribute;
    }

    public String getOriginalQueryAttribute() {
        return this.originalQueryAttribute;
    }

    public void setOriginalQueryAttribute(String originalQueryAttribute) {
        this.originalQueryAttribute = originalQueryAttribute;
    }

    public boolean isFastCGISecure() {
        return this.fcgiSecure;
    }

    public void setFastCGISecure(boolean fcgiSecure) {
        this.fcgiSecure = fcgiSecure;
    }

    public Set<String> getFastCGIEnvNames() {
        return this.fcgiEnvNames;
    }

    public void setFastCGIEnvNames(Set<String> fcgiEnvNames) {
        this.fcgiEnvNames = fcgiEnvNames;
    }

    public Path getUnixDomainPath() {
        return this.unixDomainPath;
    }

    public void setUnixDomainPath(Path unixDomainPath) {
        this.unixDomainPath = unixDomainPath;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.scriptPattern == null) {
            this.scriptPattern = Pattern.compile("(.+?\\.php)");
        }
        if (this.fcgiEnvNames == null) {
            this.fcgiEnvNames = Set.of();
        }
    }

    protected HttpClient newHttpClient() {
        ClientConnector clientConnector = new ClientConnector();
        QueuedThreadPool proxyClientThreads = new QueuedThreadPool();
        proxyClientThreads.setName("proxy-client");
        clientConnector.setExecutor((Executor)proxyClientThreads);
        return new HttpClient((HttpClientTransport)new ProxyHttpClientTransportOverFCGI(clientConnector, this.getScriptRoot()));
    }

    protected void sendProxyToServerRequest(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest, Response proxyToClientResponse, Callback proxyToClientCallback) {
        Path unixDomain;
        List cookies;
        String originalQueryAttribute;
        proxyToServerRequest.attribute(REMOTE_ADDR_ATTRIBUTE, (Object)org.eclipse.jetty.server.Request.getRemoteAddr((org.eclipse.jetty.server.Request)clientToProxyRequest));
        proxyToServerRequest.attribute(REMOTE_PORT_ATTRIBUTE, (Object)String.valueOf(org.eclipse.jetty.server.Request.getRemotePort((org.eclipse.jetty.server.Request)clientToProxyRequest)));
        Object serverName = org.eclipse.jetty.server.Request.getServerName((org.eclipse.jetty.server.Request)clientToProxyRequest);
        proxyToServerRequest.attribute(SERVER_NAME_ATTRIBUTE, serverName);
        proxyToServerRequest.attribute(SERVER_ADDR_ATTRIBUTE, (Object)org.eclipse.jetty.server.Request.getLocalAddr((org.eclipse.jetty.server.Request)clientToProxyRequest));
        int serverPort = org.eclipse.jetty.server.Request.getServerPort((org.eclipse.jetty.server.Request)clientToProxyRequest);
        proxyToServerRequest.attribute(SERVER_PORT_ATTRIBUTE, (Object)String.valueOf(serverPort));
        String scheme = clientToProxyRequest.getHttpURI().getScheme();
        proxyToServerRequest.attribute(SCHEME_ATTRIBUTE, (Object)scheme);
        Object originalPath = null;
        String originalQuery = null;
        String originalPathAttribute = this.getOriginalPathAttribute();
        if (originalPathAttribute != null) {
            originalPath = (String)clientToProxyRequest.getAttribute(originalPathAttribute);
        }
        if (originalPath != null && (originalQueryAttribute = this.getOriginalQueryAttribute()) != null && (originalQuery = (String)clientToProxyRequest.getAttribute(originalQueryAttribute)) != null) {
            originalPath = (String)originalPath + "?" + originalQuery;
        }
        if (originalPath != null) {
            proxyToServerRequest.attribute(REQUEST_URI_ATTRIBUTE, originalPath);
        }
        if (originalQuery != null) {
            proxyToServerRequest.attribute(REQUEST_QUERY_ATTRIBUTE, originalQuery);
        }
        if (!proxyToServerRequest.getHeaders().contains(HttpHeader.HOST)) {
            if (serverPort != URIUtil.getDefaultPortForScheme((String)scheme)) {
                serverName = (String)serverName + ":" + serverPort;
            }
            String host = serverName;
            proxyToServerRequest.headers(headers -> headers.put(HttpHeader.HOST, host).put(HttpHeader.X_FORWARDED_HOST, host));
        }
        if ((cookies = proxyToServerRequest.getHeaders().getValuesList(HttpHeader.COOKIE)).size() > 1) {
            String allCookies = String.join((CharSequence)"; ", cookies);
            proxyToServerRequest.headers(headers -> headers.put(HttpHeader.COOKIE, allCookies));
        }
        if ((unixDomain = this.getUnixDomainPath()) != null) {
            proxyToServerRequest.transport((Transport)new Transport.TCPUnix(unixDomain));
        }
        super.sendProxyToServerRequest(clientToProxyRequest, proxyToServerRequest, proxyToClientResponse, proxyToClientCallback);
    }

    protected void customizeFastCGIHeaders(Request proxyToServerRequest, HttpFields.Mutable fastCGIHeaders) {
        URI proxyRequestURI;
        for (String envName : this.getFastCGIEnvNames()) {
            String envValue = System.getenv(envName);
            if (envValue == null) continue;
            fastCGIHeaders.put(envName, envValue);
        }
        fastCGIHeaders.remove("HTTP_PROXY");
        fastCGIHeaders.put("REMOTE_ADDR", (String)proxyToServerRequest.getAttributes().get(REMOTE_ADDR_ATTRIBUTE));
        fastCGIHeaders.put("REMOTE_PORT", (String)proxyToServerRequest.getAttributes().get(REMOTE_PORT_ATTRIBUTE));
        fastCGIHeaders.put("SERVER_NAME", (String)proxyToServerRequest.getAttributes().get(SERVER_NAME_ATTRIBUTE));
        fastCGIHeaders.put("SERVER_ADDR", (String)proxyToServerRequest.getAttributes().get(SERVER_ADDR_ATTRIBUTE));
        fastCGIHeaders.put("SERVER_PORT", (String)proxyToServerRequest.getAttributes().get(SERVER_PORT_ATTRIBUTE));
        if (this.isFastCGISecure() || HttpScheme.HTTPS.is((String)proxyToServerRequest.getAttributes().get(SCHEME_ATTRIBUTE))) {
            fastCGIHeaders.put("HTTPS", "on");
        }
        String rawPath = (proxyRequestURI = proxyToServerRequest.getURI()) == null ? proxyToServerRequest.getPath() : proxyRequestURI.getRawPath();
        String rawQuery = proxyRequestURI == null ? null : proxyRequestURI.getRawQuery();
        Object requestURI = (String)proxyToServerRequest.getAttributes().get(REQUEST_URI_ATTRIBUTE);
        if (requestURI == null) {
            requestURI = rawPath;
            if (rawQuery != null) {
                requestURI = (String)requestURI + "?" + rawQuery;
            }
        }
        fastCGIHeaders.put("REQUEST_URI", (String)requestURI);
        String requestQuery = (String)proxyToServerRequest.getAttributes().get(REQUEST_QUERY_ATTRIBUTE);
        if (requestQuery != null) {
            fastCGIHeaders.put("QUERY_STRING", requestQuery);
        }
        String scriptName = rawPath;
        Matcher matcher = this.getScriptPattern().matcher(rawPath);
        if (matcher.matches()) {
            scriptName = matcher.group(1);
            if (matcher.groupCount() > 1) {
                fastCGIHeaders.put("PATH_INFO", matcher.group(2));
            }
        }
        fastCGIHeaders.put("SCRIPT_NAME", scriptName);
        String root = fastCGIHeaders.get("DOCUMENT_ROOT");
        fastCGIHeaders.put("SCRIPT_FILENAME", root + scriptName);
    }

    private class ProxyHttpClientTransportOverFCGI
    extends HttpClientTransportOverFCGI {
        private ProxyHttpClientTransportOverFCGI(ClientConnector connector, String scriptRoot) {
            super(connector, scriptRoot);
        }

        public void customize(Request proxyToServerRequest, HttpFields.Mutable fastCGIHeaders) {
            super.customize(proxyToServerRequest, fastCGIHeaders);
            FastCGIProxyHandler.this.customizeFastCGIHeaders(proxyToServerRequest, fastCGIHeaders);
            if (LOG.isDebugEnabled()) {
                TreeMap<String, String> fcgi = new TreeMap<String, String>();
                for (HttpField field : fastCGIHeaders) {
                    fcgi.put(field.getName(), field.getValue());
                }
                String eol = System.lineSeparator();
                LOG.debug("FastCGI variables {}{}", (Object)eol, (Object)fcgi.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(eol)));
            }
        }
    }
}

