/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.eclipse.jetty.quic.quiche.QuicheBinding;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuicheConnection {
    private static final Logger LOG = LoggerFactory.getLogger(QuicheConnection.class);
    static final QuicheBinding QUICHE_BINDING;

    public static QuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer) throws IOException {
        return QuicheConnection.connect(quicheConfig, local, peer, 20);
    }

    public static QuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer, int connectionIdLength) throws IOException {
        return QUICHE_BINDING.connect(quicheConfig, local, peer, connectionIdLength);
    }

    public static boolean negotiate(TokenMinter tokenMinter, ByteBuffer packetRead, ByteBuffer packetToSend) throws IOException {
        return QUICHE_BINDING.negotiate(tokenMinter, packetRead, packetToSend);
    }

    public static QuicheConnection tryAccept(QuicheConfig quicheConfig, TokenValidator tokenValidator, ByteBuffer packetRead, SocketAddress local, SocketAddress peer) throws IOException {
        return QUICHE_BINDING.tryAccept(quicheConfig, tokenValidator, packetRead, local, peer);
    }

    public final List<Long> readableStreamIds() {
        return this.iterableStreamIds(false);
    }

    public final List<Long> writableStreamIds() {
        return this.iterableStreamIds(true);
    }

    protected abstract List<Long> iterableStreamIds(boolean var1);

    public abstract int feedCipherBytes(ByteBuffer var1, SocketAddress var2, SocketAddress var3) throws IOException;

    public abstract int drainCipherBytes(ByteBuffer var1) throws IOException;

    public abstract boolean isConnectionClosed();

    public abstract boolean isConnectionEstablished();

    public abstract long nextTimeout();

    public abstract void onTimeout();

    public abstract String getNegotiatedProtocol();

    public abstract boolean close(long var1, String var3);

    public abstract void dispose();

    public abstract boolean isDraining();

    public abstract int maxLocalStreams();

    public abstract long windowCapacity();

    public abstract long windowCapacity(long var1) throws IOException;

    public abstract void shutdownStream(long var1, boolean var3, long var4) throws IOException;

    public final void feedFinForStream(long streamId) throws IOException {
        this.feedClearBytesForStream(streamId, BufferUtil.EMPTY_BUFFER, true);
    }

    public final int feedClearBytesForStream(long streamId, ByteBuffer buffer) throws IOException {
        return this.feedClearBytesForStream(streamId, buffer, false);
    }

    public abstract int feedClearBytesForStream(long var1, ByteBuffer var3, boolean var4) throws IOException;

    public abstract int drainClearBytesForStream(long var1, ByteBuffer var3) throws IOException;

    public abstract boolean isStreamFinished(long var1);

    public abstract CloseInfo getRemoteCloseInfo();

    public abstract CloseInfo getLocalCloseInfo();

    public abstract byte[] getPeerCertificate();

    static {
        List bindings = TypeUtil.serviceStream(ServiceLoader.load(QuicheBinding.class)).sorted(Comparator.comparingInt(QuicheBinding::priority)).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("found quiche binding implementations: {}", bindings);
        }
        ArrayList failures = new ArrayList();
        QUICHE_BINDING = bindings.stream().filter(quicheBinding -> {
            Throwable failure = quicheBinding.initialize();
            failures.add(failure);
            return failure == null;
        }).min(Comparator.comparingInt(QuicheBinding::priority)).orElseThrow(() -> {
            IllegalStateException ise = new IllegalStateException("no quiche binding implementation found");
            failures.forEach(ise::addSuppressed);
            return ise;
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("using quiche binding implementation: {}", (Object)QUICHE_BINDING.getClass().getName());
        }
    }

    public static interface TokenMinter {
        public static final int MAX_TOKEN_LENGTH = 48;

        public byte[] mint(byte[] var1, int var2);
    }

    public static interface TokenValidator {
        public byte[] validate(byte[] var1, int var2);
    }

    public static class TokenValidationException
    extends IOException {
        public TokenValidationException(String msg) {
            super(msg);
        }
    }

    public static class CloseInfo {
        private final long error;
        private final String reason;

        public CloseInfo(long error, String reason) {
            this.error = error;
            this.reason = reason;
        }

        public long error() {
            return this.error;
        }

        public String reason() {
            return this.reason;
        }
    }
}

