/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.websocket.jakarta.common;

import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import java.lang.invoke.MethodHandle;
import org.eclipse.jetty.ee9.websocket.jakarta.common.JakartaWebSocketMessageMetadata;
import org.eclipse.jetty.ee9.websocket.jakarta.common.decoders.AvailableDecoders;
import org.eclipse.jetty.ee9.websocket.jakarta.common.encoders.AvailableEncoders;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.InvalidWebSocketException;

public class JakartaWebSocketFrameHandlerMetadata {
    private static final String[] NO_VARIABLES = new String[0];
    private final AvailableDecoders availableDecoders;
    private final AvailableEncoders availableEncoders;
    private MethodHandle openHandle;
    private MethodHandle closeHandle;
    private MethodHandle errorHandle;
    private MethodHandle pongHandle;
    private JakartaWebSocketMessageMetadata textMetadata;
    private JakartaWebSocketMessageMetadata binaryMetadata;
    private UriTemplatePathSpec uriTemplatePathSpec;

    public JakartaWebSocketFrameHandlerMetadata(EndpointConfig endpointConfig, WebSocketComponents components) {
        this.availableDecoders = new AvailableDecoders(endpointConfig, components);
        this.availableEncoders = new AvailableEncoders(endpointConfig, components);
    }

    public AvailableDecoders getAvailableDecoders() {
        return this.availableDecoders;
    }

    public AvailableEncoders getAvailableEncoders() {
        return this.availableEncoders;
    }

    public JakartaWebSocketMessageMetadata getBinaryMetadata() {
        return this.binaryMetadata;
    }

    public MethodHandle getCloseHandle() {
        return this.closeHandle;
    }

    public MethodHandle getErrorHandle() {
        return this.errorHandle;
    }

    public MethodHandle getOpenHandle() {
        return this.openHandle;
    }

    public void setUriTemplatePathSpec(UriTemplatePathSpec pathSpec) {
        this.uriTemplatePathSpec = pathSpec;
    }

    public UriTemplatePathSpec getUriTemplatePathSpec() {
        return this.uriTemplatePathSpec;
    }

    public String[] getNamedTemplateVariables() {
        if (this.uriTemplatePathSpec != null) {
            return this.uriTemplatePathSpec.getVariables();
        }
        return NO_VARIABLES;
    }

    public MethodHandle getPongHandle() {
        return this.pongHandle;
    }

    public JakartaWebSocketMessageMetadata getTextMetadata() {
        return this.textMetadata;
    }

    public boolean hasBinaryMetadata() {
        return this.binaryMetadata != null;
    }

    public boolean hasTextMetdata() {
        return this.textMetadata != null;
    }

    public void setBinaryMetadata(JakartaWebSocketMessageMetadata metadata, Object origin) {
        this.assertNotSet(this.binaryMetadata, "BINARY Message Metadata", origin);
        this.binaryMetadata = metadata;
    }

    public void setCloseHandler(MethodHandle close, Object origin) {
        this.assertNotSet(this.closeHandle, "CLOSE Handler", origin);
        this.closeHandle = close;
    }

    public void setEncoders(Class<? extends Encoder>[] encoders) {
        this.availableEncoders.registerAll(encoders);
    }

    public void setErrorHandler(MethodHandle error, Object origin) {
        this.assertNotSet(this.errorHandle, "ERROR Handler", origin);
        this.errorHandle = error;
    }

    public void setOpenHandler(MethodHandle open, Object origin) {
        this.assertNotSet(this.openHandle, "OPEN Handler", origin);
        this.openHandle = open;
    }

    public void setPongHandle(MethodHandle pong, Object origin) {
        this.assertNotSet(this.pongHandle, "PONG Handler", origin);
        this.pongHandle = pong;
    }

    public void setTextMetadata(JakartaWebSocketMessageMetadata metadata, Object origin) {
        this.assertNotSet(this.textMetadata, "TEXT Messsage Metadata", origin);
        this.textMetadata = metadata;
    }

    private void assertNotSet(Object val, String role, Object origin) {
        if (val == null) {
            return;
        }
        StringBuilder err = new StringBuilder();
        err.append("Cannot replace previously assigned [");
        err.append(role);
        err.append("] at ").append(this.describeOrigin(val));
        err.append(" with ");
        err.append(this.describeOrigin(origin));
        throw new InvalidWebSocketException(err.toString());
    }

    private String describeOrigin(Object obj) {
        if (obj == null) {
            return "<undefined>";
        }
        return obj.toString();
    }
}

