/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.security.jaspi.provider;

import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.ee9.security.jaspi.provider.SimpleAuthConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaspiAuthConfigProvider
implements AuthConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JaspiAuthConfigProvider.class);
    private final Map providerProperties;
    private final ServerAuthModule serverAuthModule;

    public JaspiAuthConfigProvider(Map properties, AuthConfigFactory factory) {
        if (properties == null || !properties.containsKey("ServerAuthModule")) {
            throw new IllegalArgumentException("Missing property 'ServerAuthModule', cannot create JaspiAuthConfigProvider");
        }
        this.providerProperties = Map.copyOf(properties);
        this.serverAuthModule = JaspiAuthConfigProvider.createServerAuthModule((String)properties.get("ServerAuthModule"));
        if (factory != null) {
            factory.registerConfigProvider((AuthConfigProvider)this, "HttpServlet", (String)properties.get("appContext"), "Self Registration");
        }
    }

    public JaspiAuthConfigProvider(String className) {
        this(className, null);
    }

    public JaspiAuthConfigProvider(String className, Map properties) {
        this(JaspiAuthConfigProvider.createServerAuthModule(className), properties);
    }

    public JaspiAuthConfigProvider(ServerAuthModule serverAuthModule) {
        this.serverAuthModule = Objects.requireNonNull(serverAuthModule);
        this.providerProperties = Collections.emptyMap();
    }

    public JaspiAuthConfigProvider(ServerAuthModule serverAuthModule, Map properties) {
        this.serverAuthModule = Objects.requireNonNull(serverAuthModule);
        this.providerProperties = properties == null ? Collections.emptyMap() : Map.copyOf(properties);
    }

    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) {
        return null;
    }

    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getServerAuthConfig");
        }
        return new SimpleAuthConfig(layer, appContext, handler, this.providerProperties, this.serverAuthModule);
    }

    public void refresh() {
    }

    private static ServerAuthModule createServerAuthModule(String serverAuthModuleClassName) {
        try {
            return (ServerAuthModule)Class.forName(serverAuthModuleClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

