/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import org.apache.maven.tools.plugin.generator.Converter;
import org.codehaus.plexus.util.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class HtmlToPlainTextConverter
implements Converter {
    @Override
    public String convert(String text) {
        if (StringUtils.isBlank((String)text)) {
            return text;
        }
        Document document = Jsoup.parse((String)text);
        return this.getPlainText((Element)document);
    }

    private String getPlainText(Element element) {
        FormattingVisitor formatter = new FormattingVisitor();
        NodeTraversor.traverse((NodeVisitor)formatter, (Node)element);
        return formatter.toString();
    }

    private static class FormattingVisitor
    implements NodeVisitor {
        private StringBuilder accum = new StringBuilder();

        private FormattingVisitor() {
        }

        public void head(Node node, int depth) {
            String name = node.nodeName();
            if (node instanceof TextNode) {
                this.accum.append(((TextNode)node).text());
            } else if (name.equals("li")) {
                this.accum.append("\n * ");
            } else if (name.equals("dt")) {
                this.accum.append("  ");
            } else if (StringUtil.in((String)name, (String[])new String[]{"p", "h1", "h2", "h3", "h4", "h5", "tr"})) {
                this.accum.append("\n");
            }
        }

        public void tail(Node node, int depth) {
            String link;
            String name = node.nodeName();
            if (StringUtil.in((String)name, (String[])new String[]{"br", "dd", "dt", "p", "h1", "h2", "h3", "h4", "h5"})) {
                this.accum.append("\n");
            } else if (name.equals("a") && !(link = node.absUrl("href")).isEmpty()) {
                this.accum.append(String.format(" <%s>", link));
            }
        }

        public String toString() {
            return this.accum.toString().replaceAll(" +", " ").replace("\n ", "\n");
        }
    }
}

