/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Logger;
import net.zaiyers.UUIDDB.core.CachedStorage;
import net.zaiyers.UUIDDB.core.Storage;
import net.zaiyers.UUIDDB.core.StorageException;
import net.zaiyers.UUIDDB.core.UUIDDBPlugin;
import net.zaiyers.UUIDDB.velocity.PlayerJoinListener;
import net.zaiyers.UUIDDB.velocity.PluginConfig;
import net.zaiyers.UUIDDB.velocity.UuidDbCommand;
import org.spongepowered.configurate.ConfigurationNode;

public class UUIDDB
implements UUIDDBPlugin {
    private final ProxyServer proxy;
    private final Logger logger;
    private final Path dataFolder;
    private Storage storage;
    private PluginConfig cfg;
    private boolean enabled = false;

    @Inject
    public UUIDDB(ProxyServer proxy, Logger logger, @DataDirectory Path dataFolder) {
        this.proxy = proxy;
        this.logger = logger;
        this.dataFolder = dataFolder;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            this.getLogger().severe("Can not load configuration. UUIDDB will not be enabled.");
            e.printStackTrace();
            return;
        }
        String mongoHost = this.getConfig().getString("mongo.host", "localhost");
        String storageType = this.getConfig().getString("storage", "mongo");
        try {
            ConfigurationNode dV = this.getConfig().getRawConfig(storageType);
            HashMap values = new HashMap();
            if (dV.isMap()) {
                dV.childrenMap().forEach((k, v) -> values.put(k.toString(), v.getString()));
            }
            this.storage = new CachedStorage((UUIDDBPlugin)this, new Storage.Config(storageType, values), this.getConfig().getInt("cachesize", 1000));
            if (this.getConfig().getBoolean("log")) {
                this.proxy.getEventManager().register((Object)this, (Object)new PlayerJoinListener(this));
            }
            this.proxy.getCommandManager().register(this.proxy.getCommandManager().metaBuilder("uuiddb").aliases(new String[]{"uuidinfo", "uuid"}).plugin((Object)this).build(), (Command)new UuidDbCommand(this, "uuiddb.command"));
        }
        catch (UnknownHostException e) {
            this.getLogger().severe("Unknown host: " + mongoHost);
            return;
        }
        catch (StorageException e) {
            this.getLogger().severe(e.getMessage());
            e.printStackTrace();
            this.getLogger().severe("Failed to connect to mongodb");
            return;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe(e.getMessage());
            return;
        }
        this.enabled = true;
    }

    public void onDisable() {
        this.getStorage().disable();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated
    public String getNameByUUID(UUID uuid) {
        return this.getNameByUUID(uuid.toString());
    }

    @Deprecated
    public String getNameByUUID(String uuid) {
        return this.getStorage().getNameByUUID(uuid);
    }

    @Deprecated
    public void insert(UUID uniqueId, String name) {
        this.getStorage().insert(uniqueId, name);
    }

    @Deprecated
    public boolean exists(UUID uuid, String name) {
        return this.getStorage().exists(uuid, name);
    }

    @Deprecated
    public String getUUIDByName(String name) {
        return this.getStorage().getUUIDByName(name);
    }

    @Deprecated
    public String getUUIDByName(String name, boolean casesensitive) {
        return this.getStorage().getUUIDByName(name, casesensitive);
    }

    private void loadConfig() throws IOException {
        if (this.cfg == null) {
            this.cfg = new PluginConfig(this, this.dataFolder.resolve("config.yml"));
            this.cfg.createDefaultConfig();
            this.cfg.load();
        }
    }

    private PluginConfig getConfig() {
        return this.cfg;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public PluginDescription getDescription() {
        return ((PluginContainer)this.proxy.getPluginManager().fromInstance((Object)this).get()).getDescription();
    }
}

