/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.management;

import java.util.concurrent.atomic.AtomicInteger;
import net.zaiyers.UUIDDB.lib.mongodb.ServerAddress;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ConnectionPoolSettings;
import net.zaiyers.UUIDDB.lib.mongodb.event.ConnectionCheckedInEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ConnectionCheckedOutEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ConnectionClosedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ConnectionCreatedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ConnectionPoolCreatedEvent;
import net.zaiyers.UUIDDB.lib.mongodb.event.ConnectionPoolListener;
import net.zaiyers.UUIDDB.lib.mongodb.management.ConnectionPoolStatisticsMBean;

final class ConnectionPoolStatistics
implements ConnectionPoolListener,
ConnectionPoolStatisticsMBean {
    private final ServerAddress serverAddress;
    private final ConnectionPoolSettings settings;
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger checkedOutCount = new AtomicInteger();

    ConnectionPoolStatistics(ConnectionPoolCreatedEvent event) {
        this.serverAddress = event.getServerId().getAddress();
        this.settings = event.getSettings();
    }

    @Override
    public String getHost() {
        return this.serverAddress.getHost();
    }

    @Override
    public int getPort() {
        return this.serverAddress.getPort();
    }

    @Override
    public int getMinSize() {
        return this.settings.getMinSize();
    }

    @Override
    public int getMaxSize() {
        return this.settings.getMaxSize();
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public int getCheckedOutCount() {
        return this.checkedOutCount.get();
    }

    @Override
    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        this.checkedOutCount.incrementAndGet();
    }

    @Override
    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        this.checkedOutCount.decrementAndGet();
    }

    @Override
    public void connectionCreated(ConnectionCreatedEvent event) {
        this.size.incrementAndGet();
    }

    @Override
    public void connectionClosed(ConnectionClosedEvent event) {
        this.size.decrementAndGet();
    }
}

