/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.operation;

import net.zaiyers.UUIDDB.lib.bson.BsonBoolean;
import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonInt32;
import net.zaiyers.UUIDDB.lib.bson.BsonInt64;
import net.zaiyers.UUIDDB.lib.bson.BsonString;
import net.zaiyers.UUIDDB.lib.bson.BsonValue;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

final class DocumentHelper {
    private DocumentHelper() {
    }

    static void putIfTrue(BsonDocument command, String key, boolean condition) {
        if (condition) {
            command.put(key, BsonBoolean.TRUE);
        }
    }

    static void putIfFalse(BsonDocument command, String key, boolean condition) {
        if (!condition) {
            command.put(key, BsonBoolean.FALSE);
        }
    }

    static void putIfNotNullOrEmpty(BsonDocument command, String key, @Nullable BsonDocument documentValue) {
        if (documentValue != null && !documentValue.isEmpty()) {
            command.put(key, documentValue);
        }
    }

    static void putIfNotNull(BsonDocument command, String key, @Nullable BsonValue value) {
        if (value != null) {
            command.put(key, value);
        }
    }

    static void putIfNotNull(BsonDocument command, String key, @Nullable String value) {
        if (value != null) {
            command.put(key, new BsonString(value));
        }
    }

    static void putIfNotZero(BsonDocument command, String key, int value) {
        if (value != 0) {
            command.put(key, new BsonInt32(value));
        }
    }

    static void putIfNotZero(BsonDocument command, String key, long value) {
        if (value != 0L) {
            command.put(key, new BsonInt64(value));
        }
    }
}

