/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.operation;

import java.util.concurrent.TimeUnit;
import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonString;
import net.zaiyers.UUIDDB.lib.bson.BsonValue;
import net.zaiyers.UUIDDB.lib.bson.codecs.Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.Decoder;
import net.zaiyers.UUIDDB.lib.mongodb.MongoNamespace;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.Collation;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ConnectionDescription;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.AsyncBatchCursor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.AsyncReadBinding;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.ReadBinding;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.QueryResult;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.AsyncReadOperation;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.AsyncSingleBatchQueryCursor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.BatchCursor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.BsonDocumentWrapperHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.CommandOperationHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.CommandResultDocumentCodec;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.DocumentHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.OperationHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.OperationReadConcernHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.QueryBatchCursor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.ReadOperation;
import net.zaiyers.UUIDDB.lib.mongodb.internal.session.SessionContext;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

public class DistinctOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String VALUES = "values";
    private final MongoNamespace namespace;
    private final String fieldName;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private long maxTimeMS;
    private Collation collation;
    private BsonValue comment;

    public DistinctOperation(MongoNamespace namespace, String fieldName, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.fieldName = Assertions.notNull("fieldName", fieldName);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public DistinctOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public DistinctOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public DistinctOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public DistinctOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public DistinctOperation<T> comment(BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return CommandOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), this.createCommandDecoder(), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        CommandOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), this.createCommandDecoder(), this.asyncTransformer(), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, VALUES);
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result, VALUES), 0L, description.getServerAddress());
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return (result, source, connection) -> {
            QueryResult<T> queryResult = this.createQueryResult((BsonDocument)result, connection.getDescription());
            return new QueryBatchCursor<T>(queryResult, 0, 0, this.decoder, this.comment, source);
        };
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection) -> {
            QueryResult<T> queryResult = this.createQueryResult((BsonDocument)result, connection.getDescription());
            return new AsyncSingleBatchQueryCursor<T>(queryResult);
        };
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(SessionContext sessionContext) {
        return (serverDescription, connectionDescription) -> this.getCommand(sessionContext, connectionDescription);
    }

    private BsonDocument getCommand(SessionContext sessionContext, ConnectionDescription connectionDescription) {
        BsonDocument commandDocument = new BsonDocument("distinct", new BsonString(this.namespace.getCollectionName()));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, connectionDescription.getMaxWireVersion(), commandDocument);
        commandDocument.put("key", new BsonString(this.fieldName));
        DocumentHelper.putIfNotNull(commandDocument, "query", this.filter);
        DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", this.maxTimeMS);
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        DocumentHelper.putIfNotNull(commandDocument, "comment", this.comment);
        return commandDocument;
    }
}

