/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.operation;

import java.util.List;
import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonTimestamp;
import net.zaiyers.UUIDDB.lib.bson.BsonValue;
import net.zaiyers.UUIDDB.lib.bson.codecs.Decoder;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.UUIDDB.lib.bson.conversions.Bson;
import net.zaiyers.UUIDDB.lib.mongodb.AutoEncryptionSettings;
import net.zaiyers.UUIDDB.lib.mongodb.MongoNamespace;
import net.zaiyers.UUIDDB.lib.mongodb.ReadConcern;
import net.zaiyers.UUIDDB.lib.mongodb.ReadPreference;
import net.zaiyers.UUIDDB.lib.mongodb.WriteConcern;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.bulk.BulkWriteResult;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.BulkWriteOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.Collation;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.CountOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.CreateCollectionOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.CreateIndexOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.CreateViewOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.DeleteOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.DropCollectionOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.DropIndexOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.EstimatedDocumentCountOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.FindOneAndDeleteOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.FindOneAndReplaceOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.FindOneAndUpdateOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.IndexModel;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.InsertManyOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.InsertOneOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.MapReduceAction;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.RenameCollectionOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.ReplaceOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.UpdateOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.WriteModel;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.changestream.FullDocument;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.changestream.FullDocumentBeforeChange;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.AsyncBatchCursor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.client.model.AggregationLevel;
import net.zaiyers.UUIDDB.lib.mongodb.internal.client.model.FindOptions;
import net.zaiyers.UUIDDB.lib.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.AsyncExplainableReadOperation;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.AsyncReadOperation;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.AsyncWriteOperation;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.MapReduceAsyncBatchCursor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.MapReduceStatistics;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.Operations;

public final class AsyncOperations<TDocument> {
    private final Operations<TDocument> operations;

    public AsyncOperations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads) {
        this.operations = new Operations<TDocument>(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcern, retryWrites, retryReads);
    }

    public MongoNamespace getNamespace() {
        return Assertions.assertNotNull(this.operations.getNamespace());
    }

    public Class<TDocument> getDocumentClass() {
        return this.operations.getDocumentClass();
    }

    public ReadPreference getReadPreference() {
        return this.operations.getReadPreference();
    }

    public CodecRegistry getCodecRegistry() {
        return this.operations.getCodecRegistry();
    }

    public ReadConcern getReadConcern() {
        return this.operations.getReadConcern();
    }

    public WriteConcern getWriteConcern() {
        return this.operations.getWriteConcern();
    }

    public boolean isRetryWrites() {
        return this.operations.isRetryWrites();
    }

    public boolean isRetryReads() {
        return this.operations.isRetryReads();
    }

    public AsyncReadOperation<Long> countDocuments(Bson filter, CountOptions options) {
        return this.operations.countDocuments(filter, options);
    }

    public AsyncReadOperation<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.operations.estimatedDocumentCount(options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> findFirst(Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.findFirst(filter, resultClass, options);
    }

    public <TResult> AsyncExplainableReadOperation<AsyncBatchCursor<TResult>> find(Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(filter, resultClass, options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> find(MongoNamespace findNamespace, Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(findNamespace, filter, resultClass, options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> distinct(String fieldName, Bson filter, Class<TResult> resultClass, long maxTimeMS, Collation collation, BsonValue comment) {
        return this.operations.distinct(fieldName, filter, resultClass, maxTimeMS, collation, comment);
    }

    public <TResult> AsyncExplainableReadOperation<AsyncBatchCursor<TResult>> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass, long maxTimeMS, long maxAwaitTimeMS, Integer batchSize, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, Boolean allowDiskUse, AggregationLevel aggregationLevel) {
        return this.operations.aggregate(pipeline, resultClass, maxTimeMS, maxAwaitTimeMS, batchSize, collation, hint, hintString, comment, variables, allowDiskUse, aggregationLevel);
    }

    public AsyncReadOperation<Void> aggregateToCollection(List<? extends Bson> pipeline, long maxTimeMS, Boolean allowDiskUse, Boolean bypassDocumentValidation, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, AggregationLevel aggregationLevel) {
        return this.operations.aggregateToCollection(pipeline, maxTimeMS, allowDiskUse, bypassDocumentValidation, collation, hint, hintString, comment, variables, aggregationLevel);
    }

    public AsyncWriteOperation<MapReduceStatistics> mapReduceToCollection(String databaseName, String collectionName, String mapFunction, String reduceFunction, String finalizeFunction, Bson filter, int limit, long maxTimeMS, boolean jsMode, Bson scope, Bson sort, boolean verbose, MapReduceAction action, boolean nonAtomic, boolean sharded, Boolean bypassDocumentValidation, Collation collation) {
        return this.operations.mapReduceToCollection(databaseName, collectionName, mapFunction, reduceFunction, finalizeFunction, filter, limit, maxTimeMS, jsMode, scope, sort, verbose, action, nonAtomic, sharded, bypassDocumentValidation, collation);
    }

    public <TResult> AsyncReadOperation<MapReduceAsyncBatchCursor<TResult>> mapReduce(String mapFunction, String reduceFunction, String finalizeFunction, Class<TResult> resultClass, Bson filter, int limit, long maxTimeMS, boolean jsMode, Bson scope, Bson sort, boolean verbose, Collation collation) {
        return this.operations.mapReduce(mapFunction, reduceFunction, finalizeFunction, resultClass, filter, limit, maxTimeMS, jsMode, scope, sort, verbose, collation);
    }

    public AsyncWriteOperation<TDocument> findOneAndDelete(Bson filter, FindOneAndDeleteOptions options) {
        return this.operations.findOneAndDelete(filter, options);
    }

    public AsyncWriteOperation<TDocument> findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return this.operations.findOneAndReplace(filter, replacement, options);
    }

    public AsyncWriteOperation<TDocument> findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter, update, options);
    }

    public AsyncWriteOperation<TDocument> findOneAndUpdate(Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter, update, options);
    }

    public AsyncWriteOperation<BulkWriteResult> insertOne(TDocument document, InsertOneOptions options) {
        return this.operations.insertOne(document, options);
    }

    public AsyncWriteOperation<BulkWriteResult> replaceOne(Bson filter, TDocument replacement, ReplaceOptions options) {
        return this.operations.replaceOne(filter, replacement, options);
    }

    public AsyncWriteOperation<BulkWriteResult> deleteOne(Bson filter, DeleteOptions options) {
        return this.operations.deleteOne(filter, options);
    }

    public AsyncWriteOperation<BulkWriteResult> deleteMany(Bson filter, DeleteOptions options) {
        return this.operations.deleteMany(filter, options);
    }

    public AsyncWriteOperation<BulkWriteResult> updateOne(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateOne(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateMany(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> updateMany(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter, update, updateOptions);
    }

    public AsyncWriteOperation<BulkWriteResult> insertMany(List<? extends TDocument> documents, InsertManyOptions options) {
        return this.operations.insertMany(documents, options);
    }

    public AsyncWriteOperation<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.operations.bulkWrite(requests, options);
    }

    public <TResult> AsyncReadOperation<TResult> commandRead(Bson command, Class<TResult> resultClass) {
        return this.operations.commandRead(command, resultClass);
    }

    public AsyncWriteOperation<Void> dropDatabase() {
        return this.operations.dropDatabase();
    }

    public AsyncWriteOperation<Void> createCollection(String collectionName, CreateCollectionOptions createCollectionOptions, AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.createCollection(collectionName, createCollectionOptions, autoEncryptionSettings);
    }

    public AsyncWriteOperation<Void> dropCollection(DropCollectionOptions dropCollectionOptions, AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.dropCollection(dropCollectionOptions, autoEncryptionSettings);
    }

    public AsyncWriteOperation<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.operations.renameCollection(newCollectionNamespace, options);
    }

    public AsyncWriteOperation<Void> createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        return this.operations.createView(viewName, viewOn, pipeline, createViewOptions);
    }

    public AsyncWriteOperation<Void> createIndexes(List<IndexModel> indexes, CreateIndexOptions options) {
        return this.operations.createIndexes(indexes, options);
    }

    public AsyncWriteOperation<Void> dropIndex(String indexName, DropIndexOptions options) {
        return this.operations.dropIndex(indexName, options);
    }

    public AsyncWriteOperation<Void> dropIndex(Bson keys, DropIndexOptions options) {
        return this.operations.dropIndex(keys, options);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listCollections(String databaseName, Class<TResult> resultClass, Bson filter, boolean collectionNamesOnly, Integer batchSize, long maxTimeMS, BsonValue comment) {
        return this.operations.listCollections(databaseName, resultClass, filter, collectionNamesOnly, batchSize, maxTimeMS, comment);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listDatabases(Class<TResult> resultClass, Bson filter, Boolean nameOnly, long maxTimeMS, Boolean authorizedDatabases, BsonValue comment) {
        return this.operations.listDatabases(resultClass, filter, nameOnly, maxTimeMS, authorizedDatabases, comment);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> listIndexes(Class<TResult> resultClass, Integer batchSize, long maxTimeMS, BsonValue comment) {
        return this.operations.listIndexes(resultClass, batchSize, maxTimeMS, comment);
    }

    public <TResult> AsyncReadOperation<AsyncBatchCursor<TResult>> changeStream(FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<? extends Bson> pipeline, Decoder<TResult> decoder, ChangeStreamLevel changeStreamLevel, Integer batchSize, Collation collation, BsonValue comment, long maxAwaitTimeMS, BsonDocument resumeToken, BsonTimestamp startAtOperationTime, BsonDocument startAfter, boolean showExpandedEvents) {
        return this.operations.changeStream(fullDocument, fullDocumentBeforeChange, pipeline, decoder, changeStreamLevel, batchSize, collation, comment, maxAwaitTimeMS, resumeToken, startAtOperationTime, startAfter, showExpandedEvents);
    }
}

