/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.operation;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonTimestamp;
import net.zaiyers.UUIDDB.lib.bson.RawBsonDocument;
import net.zaiyers.UUIDDB.lib.mongodb.MongoException;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.UUIDDB.lib.mongodb.internal.binding.AsyncReadBinding;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.ChangeStreamBatchCursor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.ChangeStreamOperation;
import net.zaiyers.UUIDDB.lib.mongodb.internal.operation.OperationHelper;
import net.zaiyers.UUIDDB.lib.mongodb.lang.NonNull;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

final class AsyncChangeStreamBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private final AsyncReadBinding binding;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private volatile BsonDocument resumeToken;
    private final AtomicReference<AsyncAggregateResponseBatchCursor<RawBsonDocument>> wrapped;
    private final AtomicBoolean isClosed;

    AsyncChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, AsyncAggregateResponseBatchCursor<RawBsonDocument> wrapped, AsyncReadBinding binding, @Nullable BsonDocument resumeToken, int maxWireVersion) {
        this.changeStreamOperation = changeStreamOperation;
        this.wrapped = new AtomicReference<AsyncAggregateResponseBatchCursor<RawBsonDocument>>(Assertions.assertNotNull(wrapped));
        this.binding = binding;
        binding.retain();
        this.resumeToken = resumeToken;
        this.maxWireVersion = maxWireVersion;
        this.isClosed = new AtomicBoolean();
    }

    @NonNull
    AsyncAggregateResponseBatchCursor<RawBsonDocument> getWrapped() {
        return Assertions.assertNotNull(this.wrapped.get());
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        this.resumeableOperation((cursor, callback1) -> cursor.next(callback1), callback, false);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.nullifyAndCloseWrapped();
            }
            finally {
                this.binding.release();
            }
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.getWrapped().setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.getWrapped().getBatchSize();
    }

    @Override
    public boolean isClosed() {
        if (this.isClosed.get()) {
            return true;
        }
        if (this.wrappedClosedItself()) {
            this.close();
            return true;
        }
        return false;
    }

    private boolean wrappedClosedItself() {
        AsyncAggregateResponseBatchCursor<RawBsonDocument> observedWrapped = this.wrapped.get();
        return observedWrapped != null && observedWrapped.isClosed();
    }

    private void nullifyAndCloseWrapped() {
        AsyncAggregateResponseBatchCursor observedWrapped = this.wrapped.getAndSet(null);
        if (observedWrapped != null) {
            observedWrapped.close();
        }
    }

    private void setWrappedOrCloseIt(AsyncAggregateResponseBatchCursor<RawBsonDocument> newValue) {
        if (this.isClosed()) {
            Assertions.assertNull(this.wrapped.get());
            newValue.close();
        } else {
            Assertions.assertNull(this.wrapped.getAndSet(newValue));
            if (this.isClosed()) {
                this.nullifyAndCloseWrapped();
            }
        }
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.getWrapped().getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.getWrapped().isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(AsyncAggregateResponseBatchCursor<RawBsonDocument> queryBatchCursor) {
        BsonDocument resumeToken = queryBatchCursor.getPostBatchResumeToken();
        if (resumeToken != null) {
            this.resumeToken = resumeToken;
        }
    }

    private void resumeableOperation(AsyncBlock asyncBlock, SingleResultCallback<List<T>> callback, boolean tryNext) {
        SingleResultCallback<List<Object>> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        if (this.isClosed()) {
            errHandlingCallback.onResult(null, new MongoException(String.format("%s called after the cursor was closed.", tryNext ? "tryNext()" : "next()")));
            return;
        }
        AsyncAggregateResponseBatchCursor<RawBsonDocument> wrappedCursor = this.getWrapped();
        asyncBlock.apply(wrappedCursor, (result, t) -> {
            if (t == null) {
                try {
                    List<T> convertedResults;
                    try {
                        convertedResults = ChangeStreamBatchCursor.convertAndProduceLastId(result, this.changeStreamOperation.getDecoder(), lastId -> {
                            this.resumeToken = lastId;
                        });
                    }
                    finally {
                        this.cachePostBatchResumeToken(wrappedCursor);
                    }
                    errHandlingCallback.onResult(convertedResults, null);
                }
                catch (Exception e) {
                    errHandlingCallback.onResult(null, e);
                }
            } else {
                this.cachePostBatchResumeToken(wrappedCursor);
                if (ChangeStreamBatchCursorHelper.isResumableError(t, this.maxWireVersion)) {
                    this.nullifyAndCloseWrapped();
                    this.retryOperation(asyncBlock, errHandlingCallback, tryNext);
                } else {
                    errHandlingCallback.onResult(null, t);
                }
            }
        });
    }

    private void retryOperation(AsyncBlock asyncBlock, SingleResultCallback<List<T>> callback, boolean tryNext) {
        OperationHelper.withAsyncReadConnection(this.binding, (source, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                this.changeStreamOperation.setChangeStreamOptionsForResume(this.resumeToken, source.getServerDescription().getMaxWireVersion());
                source.release();
                this.changeStreamOperation.executeAsync(this.binding, (result, t1) -> {
                    if (t1 != null) {
                        callback.onResult(null, t1);
                    } else {
                        try {
                            this.setWrappedOrCloseIt(((AsyncChangeStreamBatchCursor)result).getWrapped());
                        }
                        finally {
                            try {
                                this.binding.release();
                            }
                            finally {
                                this.resumeableOperation(asyncBlock, callback, tryNext);
                            }
                        }
                    }
                });
            }
        });
    }

    private static interface AsyncBlock {
        public void apply(AsyncAggregateResponseBatchCursor<RawBsonDocument> var1, SingleResultCallback<List<RawBsonDocument>> var2);
    }
}

