/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonInt32;
import net.zaiyers.UUIDDB.lib.bson.BsonString;
import net.zaiyers.UUIDDB.lib.mongodb.AuthenticationMechanism;
import net.zaiyers.UUIDDB.lib.mongodb.MongoCommandException;
import net.zaiyers.UUIDDB.lib.mongodb.MongoSecurityException;
import net.zaiyers.UUIDDB.lib.mongodb.ServerApi;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ConnectionDescription;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.Authenticator;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.CommandHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.InternalConnection;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.MongoCredentialWithCache;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.SpeculativeAuthenticator;
import net.zaiyers.UUIDDB.lib.mongodb.internal.diagnostics.logging.Logger;
import net.zaiyers.UUIDDB.lib.mongodb.internal.diagnostics.logging.Loggers;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

class X509Authenticator
extends Authenticator
implements SpeculativeAuthenticator {
    public static final Logger LOGGER = Loggers.getLogger("authenticator");
    private BsonDocument speculativeAuthenticateResponse;

    X509Authenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        if (this.speculativeAuthenticateResponse != null) {
            return;
        }
        try {
            BsonDocument authCommand = this.getAuthCommand(this.getMongoCredential().getUserName());
            CommandHelper.executeCommand(this.getMongoCredential().getSource(), authCommand, this.getClusterConnectionMode(), this.getServerApi(), connection);
        }
        catch (MongoCommandException e) {
            throw new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", (Throwable)e);
        }
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, SingleResultCallback<Void> callback) {
        if (this.speculativeAuthenticateResponse != null) {
            callback.onResult(null, null);
        } else {
            SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
            try {
                CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), this.getAuthCommand(this.getMongoCredential().getUserName()), this.getClusterConnectionMode(), this.getServerApi(), connection, (nonceResult, t) -> {
                    if (t != null) {
                        errHandlingCallback.onResult(null, this.translateThrowable(t));
                    } else {
                        errHandlingCallback.onResult(null, null);
                    }
                });
            }
            catch (Throwable t2) {
                errHandlingCallback.onResult(null, t2);
            }
        }
    }

    @Override
    public BsonDocument createSpeculativeAuthenticateCommand(InternalConnection connection) {
        return this.getAuthCommand(this.getMongoCredential().getUserName()).append("db", new BsonString("$external"));
    }

    @Override
    public void setSpeculativeAuthenticateResponse(BsonDocument response) {
        this.speculativeAuthenticateResponse = response;
    }

    @Override
    public BsonDocument getSpeculativeAuthenticateResponse() {
        return this.speculativeAuthenticateResponse;
    }

    private BsonDocument getAuthCommand(@Nullable String userName) {
        BsonDocument cmd = new BsonDocument();
        cmd.put("authenticate", new BsonInt32(1));
        if (userName != null) {
            cmd.put("user", new BsonString(userName));
        }
        cmd.put("mechanism", new BsonString(AuthenticationMechanism.MONGODB_X509.getMechanismName()));
        return cmd;
    }

    private Throwable translateThrowable(Throwable t) {
        if (t instanceof MongoCommandException) {
            return new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", t);
        }
        return t;
    }
}

