/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonInt32;
import net.zaiyers.UUIDDB.lib.bson.BsonReader;
import net.zaiyers.UUIDDB.lib.bson.codecs.RawBsonDocumentCodec;
import net.zaiyers.UUIDDB.lib.bson.json.JsonMode;
import net.zaiyers.UUIDDB.lib.bson.json.JsonWriter;
import net.zaiyers.UUIDDB.lib.bson.json.JsonWriterSettings;
import net.zaiyers.UUIDDB.lib.bson.types.ObjectId;
import net.zaiyers.UUIDDB.lib.mongodb.LoggerSettings;
import net.zaiyers.UUIDDB.lib.mongodb.MongoCommandException;
import net.zaiyers.UUIDDB.lib.mongodb.RequestContext;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterId;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ConnectionDescription;
import net.zaiyers.UUIDDB.lib.mongodb.event.CommandListener;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.ByteBufferBsonOutput;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.CommandEventSender;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.CommandMessage;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.ProtocolHelper;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.ResponseBuffers;
import net.zaiyers.UUIDDB.lib.mongodb.internal.logging.StructuredLogMessage;
import net.zaiyers.UUIDDB.lib.mongodb.internal.logging.StructuredLogger;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

class LoggingCommandEventSender
implements CommandEventSender {
    private static final double NANOS_PER_MILLI = 1000000.0;
    private final ConnectionDescription description;
    @Nullable
    private final CommandListener commandListener;
    private final RequestContext requestContext;
    private final StructuredLogger logger;
    private final LoggerSettings loggerSettings;
    private final long startTimeNanos;
    private final CommandMessage message;
    private final String commandName;
    private volatile BsonDocument commandDocument;
    private final boolean redactionRequired;

    LoggingCommandEventSender(Set<String> securitySensitiveCommands, Set<String> securitySensitiveHelloCommands, ConnectionDescription description, @Nullable CommandListener commandListener, RequestContext requestContext, CommandMessage message, ByteBufferBsonOutput bsonOutput, StructuredLogger logger, LoggerSettings loggerSettings) {
        this.description = description;
        this.commandListener = commandListener;
        this.requestContext = requestContext;
        this.logger = logger;
        this.loggerSettings = loggerSettings;
        this.startTimeNanos = System.nanoTime();
        this.message = message;
        this.commandDocument = message.getCommandDocument(bsonOutput);
        this.commandName = this.commandDocument.getFirstKey();
        this.redactionRequired = securitySensitiveCommands.contains(this.commandName) || securitySensitiveHelloCommands.contains(this.commandName) && this.commandDocument.containsKey("speculativeAuthenticate");
    }

    @Override
    public void sendStartedEvent() {
        if (this.loggingRequired()) {
            ArrayList<StructuredLogMessage.Entry> entries = new ArrayList<StructuredLogMessage.Entry>();
            StringBuilder builder = new StringBuilder("Command \"%s\" started on database %s");
            entries.add(new StructuredLogMessage.Entry("commandName", this.commandName));
            entries.add(new StructuredLogMessage.Entry("databaseName", this.message.getNamespace().getDatabaseName()));
            this.appendCommonLogFragment(entries, builder);
            builder.append(" Command: %s");
            entries.add(new StructuredLogMessage.Entry("command", this.redactionRequired ? "{}" : this.getTruncatedJsonCommand(this.commandDocument)));
            this.logger.log(new StructuredLogMessage(StructuredLogMessage.Component.COMMAND, StructuredLogMessage.Level.DEBUG, "Command started", this.getClusterId(), entries), builder.toString());
        }
        if (this.eventRequired()) {
            BsonDocument commandDocumentForEvent = this.redactionRequired ? new BsonDocument() : this.commandDocument;
            ProtocolHelper.sendCommandStartedEvent(this.message, this.message.getNamespace().getDatabaseName(), this.commandName, commandDocumentForEvent, this.description, Assertions.assertNotNull(this.commandListener), this.requestContext);
        }
        this.commandDocument = null;
    }

    @Override
    public void sendFailedEvent(Throwable t) {
        Throwable commandEventException = t;
        if (t instanceof MongoCommandException && this.redactionRequired) {
            MongoCommandException originalCommandException = (MongoCommandException)t;
            commandEventException = new MongoCommandException(new BsonDocument(), originalCommandException.getServerAddress());
            commandEventException.setStackTrace(t.getStackTrace());
        }
        long elapsedTimeNanos = System.nanoTime() - this.startTimeNanos;
        if (this.loggingRequired()) {
            ArrayList<StructuredLogMessage.Entry> entries = new ArrayList<StructuredLogMessage.Entry>();
            StringBuilder builder = new StringBuilder("Command \"%s\" failed in %.2f ms");
            entries.add(new StructuredLogMessage.Entry("commandName", this.commandName));
            entries.add(new StructuredLogMessage.Entry("durationMS", (double)elapsedTimeNanos / 1000000.0));
            this.appendCommonLogFragment(entries, builder);
            this.logger.log(new StructuredLogMessage(StructuredLogMessage.Component.COMMAND, StructuredLogMessage.Level.DEBUG, "Command failed", this.getClusterId(), commandEventException, entries), builder.toString());
        }
        if (this.eventRequired()) {
            ProtocolHelper.sendCommandFailedEvent(this.message, this.commandName, this.description, elapsedTimeNanos, commandEventException, this.commandListener, this.requestContext);
        }
    }

    @Override
    public void sendSucceededEvent(ResponseBuffers responseBuffers) {
        this.sendSucceededEvent(responseBuffers.getResponseDocument(this.message.getId(), new RawBsonDocumentCodec()));
    }

    @Override
    public void sendSucceededEventForOneWayCommand() {
        this.sendSucceededEvent(new BsonDocument("ok", new BsonInt32(1)));
    }

    private void sendSucceededEvent(BsonDocument reply) {
        long elapsedTimeNanos = System.nanoTime() - this.startTimeNanos;
        if (this.loggingRequired()) {
            ArrayList<StructuredLogMessage.Entry> entries = new ArrayList<StructuredLogMessage.Entry>();
            StringBuilder builder = new StringBuilder("Command \"%s\" succeeded in %.2f ms");
            entries.add(new StructuredLogMessage.Entry("commandName", this.commandName));
            entries.add(new StructuredLogMessage.Entry("durationMS", (double)elapsedTimeNanos / 1000000.0));
            this.appendCommonLogFragment(entries, builder);
            builder.append(" Command reply: %s");
            BsonDocument responseDocumentForEvent = this.redactionRequired ? new BsonDocument() : reply;
            String replyString = this.redactionRequired ? "{}" : this.getTruncatedJsonCommand(responseDocumentForEvent);
            entries.add(new StructuredLogMessage.Entry("reply", replyString));
            this.logger.log(new StructuredLogMessage(StructuredLogMessage.Component.COMMAND, StructuredLogMessage.Level.DEBUG, "Command succeeded", this.getClusterId(), entries), builder.toString());
        }
        if (this.eventRequired()) {
            BsonDocument responseDocumentForEvent = this.redactionRequired ? new BsonDocument() : reply;
            ProtocolHelper.sendCommandSucceededEvent(this.message, this.commandName, responseDocumentForEvent, this.description, elapsedTimeNanos, this.commandListener, this.requestContext);
        }
    }

    private boolean loggingRequired() {
        return this.logger.isRequired(StructuredLogMessage.Level.DEBUG, this.getClusterId());
    }

    private ClusterId getClusterId() {
        return this.description.getConnectionId().getServerId().getClusterId();
    }

    private boolean eventRequired() {
        return this.commandListener != null;
    }

    private void appendCommonLogFragment(List<StructuredLogMessage.Entry> entries, StringBuilder builder) {
        builder.append(" using a connection with driver-generated ID %d");
        entries.add(new StructuredLogMessage.Entry("driverConnectionId", this.description.getConnectionId().getLocalValue()));
        Integer connectionServerValue = this.description.getConnectionId().getServerValue();
        if (connectionServerValue != null) {
            builder.append(" and server-generated ID %d");
            entries.add(new StructuredLogMessage.Entry("serverConnectionId", connectionServerValue));
        }
        builder.append(" to %s:%s");
        entries.add(new StructuredLogMessage.Entry("serverHost", this.description.getServerAddress().getHost()));
        entries.add(new StructuredLogMessage.Entry("serverPort", this.description.getServerAddress().getPort()));
        ObjectId descriptionServiceId = this.description.getServiceId();
        if (descriptionServiceId != null) {
            builder.append(" with service ID %s");
            entries.add(new StructuredLogMessage.Entry("serviceId", descriptionServiceId));
        }
        builder.append(". The request ID is %s.");
        entries.add(new StructuredLogMessage.Entry("requestId", this.message.getId()));
    }

    private String getTruncatedJsonCommand(BsonDocument commandDocument) {
        StringWriter writer = new StringWriter();
        try (BsonReader bsonReader = commandDocument.asBsonReader();){
            JsonWriter jsonWriter = new JsonWriter(writer, JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).maxLength(this.loggerSettings.getMaxDocumentLength()).build());
            jsonWriter.pipe(bsonReader);
            if (jsonWriter.isTruncated()) {
                writer.append(" ...");
            }
            String string = writer.toString();
            return string;
        }
    }
}

