/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import net.zaiyers.UUIDDB.lib.mongodb.MongoException;
import net.zaiyers.UUIDDB.lib.mongodb.ServerAddress;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterId;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterSettings;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterType;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.AbstractMultiServerCluster;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.ClusterableServerFactory;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.DnsSrvRecordInitializer;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.DnsSrvRecordMonitor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

public final class DnsMultiServerCluster
extends AbstractMultiServerCluster {
    private final DnsSrvRecordMonitor dnsSrvRecordMonitor;
    private volatile MongoException srvResolutionException;

    public DnsMultiServerCluster(ClusterId clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory, DnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory) {
        super(clusterId, settings, serverFactory);
        this.dnsSrvRecordMonitor = dnsSrvRecordMonitorFactory.create(Assertions.assertNotNull(settings.getSrvHost()), settings.getSrvServiceName(), new DnsSrvRecordInitializer(){
            private volatile boolean initialized;

            @Override
            public void initialize(Collection<ServerAddress> hosts) {
                DnsMultiServerCluster.this.srvResolutionException = null;
                if (!this.initialized) {
                    this.initialized = true;
                    DnsMultiServerCluster.this.initialize(this.applySrvMaxHosts(hosts));
                } else {
                    DnsMultiServerCluster.this.onChange(this.applySrvMaxHosts(hosts));
                }
            }

            private Collection<ServerAddress> applySrvMaxHosts(Collection<ServerAddress> hosts) {
                Collection<ServerAddress> newHosts = hosts;
                Integer srvMaxHosts = DnsMultiServerCluster.this.getSettings().getSrvMaxHosts();
                if (srvMaxHosts != null && srvMaxHosts > 0 && srvMaxHosts < hosts.size()) {
                    ArrayList<ServerAddress> newHostsList = new ArrayList<ServerAddress>(hosts);
                    Collections.shuffle(newHostsList, ThreadLocalRandom.current());
                    newHosts = newHostsList.subList(0, srvMaxHosts);
                }
                return newHosts;
            }

            @Override
            public void initialize(MongoException initializationException) {
                if (!this.initialized) {
                    DnsMultiServerCluster.this.srvResolutionException = initializationException;
                    DnsMultiServerCluster.this.initialize(Collections.emptyList());
                }
            }

            @Override
            public ClusterType getClusterType() {
                return DnsMultiServerCluster.this.getClusterType();
            }
        });
        this.dnsSrvRecordMonitor.start();
    }

    @Override
    @Nullable
    protected MongoException getSrvResolutionException() {
        return this.srvResolutionException;
    }

    @Override
    public void close() {
        if (this.dnsSrvRecordMonitor != null) {
            this.dnsSrvRecordMonitor.close();
        }
        super.close();
    }
}

