/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import java.util.concurrent.TimeUnit;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterId;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ServerSettings;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.DefaultDnsSrvRecordMonitor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.DnsSrvRecordInitializer;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.DnsSrvRecordMonitor;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import net.zaiyers.UUIDDB.lib.mongodb.internal.dns.DefaultDnsResolver;

public class DefaultDnsSrvRecordMonitorFactory
implements DnsSrvRecordMonitorFactory {
    private static final long DEFAULT_RESCAN_FREQUENCY_MILLIS = 60000L;
    private final ClusterId clusterId;
    private final long noRecordsRescanFrequency;

    public DefaultDnsSrvRecordMonitorFactory(ClusterId clusterId, ServerSettings serverSettings) {
        this.clusterId = clusterId;
        this.noRecordsRescanFrequency = serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS);
    }

    @Override
    public DnsSrvRecordMonitor create(String hostName, String srvServiceName, DnsSrvRecordInitializer dnsSrvRecordInitializer) {
        return new DefaultDnsSrvRecordMonitor(hostName, srvServiceName, 60000L, this.noRecordsRescanFrequency, dnsSrvRecordInitializer, this.clusterId, new DefaultDnsResolver());
    }
}

