/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.zaiyers.UUIDDB.lib.mongodb.ServerAddress;
import net.zaiyers.UUIDDB.lib.mongodb.TagSet;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterDescription;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ServerDescription;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

public final class ClusterDescriptionHelper {
    public static Set<ServerDescription> getAll(ClusterDescription clusterDescription) {
        TreeSet<ServerDescription> serverDescriptionSet = new TreeSet<ServerDescription>(Comparator.comparing(o -> o.getAddress().getHost()).thenComparingInt(o -> o.getAddress().getPort()));
        serverDescriptionSet.addAll(clusterDescription.getServerDescriptions());
        return Collections.unmodifiableSet(serverDescriptionSet);
    }

    @Nullable
    public static ServerDescription getByServerAddress(ClusterDescription clusterDescription, ServerAddress serverAddress) {
        for (ServerDescription cur : clusterDescription.getServerDescriptions()) {
            if (!cur.isOk() || !cur.getAddress().equals(serverAddress)) continue;
            return cur;
        }
        return null;
    }

    public static List<ServerDescription> getPrimaries(ClusterDescription clusterDescription) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, ServerDescription::isPrimary);
    }

    public static List<ServerDescription> getSecondaries(ClusterDescription clusterDescription) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, ServerDescription::isSecondary);
    }

    public static List<ServerDescription> getSecondaries(ClusterDescription clusterDescription, TagSet tagSet) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, serverDescription -> serverDescription.isSecondary() && serverDescription.hasTags(tagSet));
    }

    public static List<ServerDescription> getAny(ClusterDescription clusterDescription) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, ServerDescription::isOk);
    }

    public static List<ServerDescription> getAnyPrimaryOrSecondary(ClusterDescription clusterDescription) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, serverDescription -> serverDescription.isPrimary() || serverDescription.isSecondary());
    }

    public static List<ServerDescription> getAnyPrimaryOrSecondary(ClusterDescription clusterDescription, TagSet tagSet) {
        return ClusterDescriptionHelper.getServersByPredicate(clusterDescription, serverDescription -> (serverDescription.isPrimary() || serverDescription.isSecondary()) && serverDescription.hasTags(tagSet));
    }

    public static List<ServerDescription> getServersByPredicate(ClusterDescription clusterDescription, Predicate predicate) {
        ArrayList<ServerDescription> membersByTag = new ArrayList<ServerDescription>();
        for (ServerDescription cur : clusterDescription.getServerDescriptions()) {
            if (!predicate.apply(cur)) continue;
            membersByTag.add(cur);
        }
        return membersByTag;
    }

    private ClusterDescriptionHelper() {
    }

    public static interface Predicate {
        public boolean apply(ServerDescription var1);
    }
}

