/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.connection;

import net.zaiyers.UUIDDB.lib.mongodb.MongoCredential;
import net.zaiyers.UUIDDB.lib.mongodb.MongoInternalException;
import net.zaiyers.UUIDDB.lib.mongodb.ServerApi;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.UUIDDB.lib.mongodb.connection.ConnectionDescription;
import net.zaiyers.UUIDDB.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.InternalConnection;
import net.zaiyers.UUIDDB.lib.mongodb.internal.connection.MongoCredentialWithCache;
import net.zaiyers.UUIDDB.lib.mongodb.lang.NonNull;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

public abstract class Authenticator {
    private final MongoCredentialWithCache credential;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ServerApi serverApi;

    Authenticator(@NonNull MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this.credential = credential;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
    }

    @NonNull
    MongoCredentialWithCache getMongoCredentialWithCache() {
        return this.credential;
    }

    @NonNull
    MongoCredential getMongoCredential() {
        return this.credential.getCredential();
    }

    ClusterConnectionMode getClusterConnectionMode() {
        return this.clusterConnectionMode;
    }

    @Nullable
    ServerApi getServerApi() {
        return this.serverApi;
    }

    @NonNull
    String getUserNameNonNull() {
        String userName = this.credential.getCredential().getUserName();
        if (userName == null) {
            throw new MongoInternalException("User name can not be null");
        }
        return userName;
    }

    @NonNull
    char[] getPasswordNonNull() {
        char[] password = this.credential.getCredential().getPassword();
        if (password == null) {
            throw new MongoInternalException("Password can not be null");
        }
        return password;
    }

    @NonNull
    <T> T getNonNullMechanismProperty(String key, @Nullable T defaultValue) {
        T mechanismProperty = this.credential.getCredential().getMechanismProperty(key, defaultValue);
        if (mechanismProperty == null) {
            throw new MongoInternalException("Mechanism property can not be null");
        }
        return mechanismProperty;
    }

    abstract void authenticate(InternalConnection var1, ConnectionDescription var2);

    abstract void authenticateAsync(InternalConnection var1, ConnectionDescription var2, SingleResultCallback<Void> var3);
}

