/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.client.vault;

import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonInt32;
import net.zaiyers.UUIDDB.lib.bson.BsonInt64;
import net.zaiyers.UUIDDB.lib.bson.BsonValue;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.vault.EncryptOptions;
import net.zaiyers.UUIDDB.lib.mongodb.client.model.vault.RangeOptions;
import net.zaiyers.UUIDDB.lib.mongodb.crypt.capi.MongoExplicitEncryptOptions;

public final class EncryptOptionsHelper {
    public static MongoExplicitEncryptOptions asMongoExplicitEncryptOptions(EncryptOptions options) {
        RangeOptions rangeOptions;
        MongoExplicitEncryptOptions.Builder encryptOptionsBuilder = MongoExplicitEncryptOptions.builder().algorithm(options.getAlgorithm());
        if (options.getKeyId() != null) {
            encryptOptionsBuilder.keyId(options.getKeyId());
        }
        if (options.getKeyAltName() != null) {
            encryptOptionsBuilder.keyAltName(options.getKeyAltName());
        }
        if (options.getContentionFactor() != null) {
            encryptOptionsBuilder.contentionFactor(options.getContentionFactor());
        }
        if (options.getQueryType() != null) {
            encryptOptionsBuilder.queryType(options.getQueryType());
        }
        if ((rangeOptions = options.getRangeOptions()) != null) {
            Integer precision;
            Long sparsity;
            BsonValue max;
            BsonDocument rangeOptionsBsonDocument = new BsonDocument();
            BsonValue min = rangeOptions.getMin();
            if (min != null) {
                rangeOptionsBsonDocument.put("min", min);
            }
            if ((max = rangeOptions.getMax()) != null) {
                rangeOptionsBsonDocument.put("max", max);
            }
            if ((sparsity = rangeOptions.getSparsity()) != null) {
                rangeOptionsBsonDocument.put("sparsity", new BsonInt64(sparsity));
            }
            if ((precision = rangeOptions.getPrecision()) != null) {
                rangeOptionsBsonDocument.put("precision", new BsonInt32(precision));
            }
            encryptOptionsBuilder.rangeOptions(rangeOptionsBsonDocument);
        }
        return encryptOptionsBuilder.build();
    }

    private EncryptOptionsHelper() {
    }
}

