/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.internal.authentication;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.zaiyers.UUIDDB.lib.mongodb.MongoClientException;
import net.zaiyers.UUIDDB.lib.mongodb.lang.NonNull;
import net.zaiyers.UUIDDB.lib.mongodb.lang.Nullable;

final class HttpHelper {
    private HttpHelper() {
    }

    @NonNull
    public static String getHttpContents(String method, String endpoint, @Nullable Map<String, String> headers) {
        StringBuilder content = new StringBuilder();
        HttpURLConnection conn = null;
        try {
            int status;
            conn = (HttpURLConnection)new URL(endpoint).openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestMethod(method);
            if (headers != null) {
                for (Map.Entry<String, String> kvp : headers.entrySet()) {
                    conn.setRequestProperty(kvp.getKey(), kvp.getValue());
                }
            }
            if ((status = conn.getResponseCode()) != 200) {
                throw new IOException(String.format("%d %s", status, conn.getResponseMessage()));
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
            }
        }
        catch (IOException e) {
            throw new MongoClientException("Unexpected IOException from endpoint " + endpoint + ".", e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return content.toString();
    }
}

