/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb.client.internal;

import java.util.Map;
import javax.net.ssl.SSLContext;
import net.zaiyers.UUIDDB.lib.mongodb.AutoEncryptionSettings;
import net.zaiyers.UUIDDB.lib.mongodb.ClientEncryptionSettings;
import net.zaiyers.UUIDDB.lib.mongodb.MongoClientSettings;
import net.zaiyers.UUIDDB.lib.mongodb.MongoNamespace;
import net.zaiyers.UUIDDB.lib.mongodb.client.MongoClient;
import net.zaiyers.UUIDDB.lib.mongodb.client.MongoClients;
import net.zaiyers.UUIDDB.lib.mongodb.client.internal.CollectionInfoRetriever;
import net.zaiyers.UUIDDB.lib.mongodb.client.internal.CommandMarker;
import net.zaiyers.UUIDDB.lib.mongodb.client.internal.Crypt;
import net.zaiyers.UUIDDB.lib.mongodb.client.internal.KeyManagementService;
import net.zaiyers.UUIDDB.lib.mongodb.client.internal.KeyRetriever;
import net.zaiyers.UUIDDB.lib.mongodb.client.internal.MongoClientImpl;
import net.zaiyers.UUIDDB.lib.mongodb.crypt.capi.MongoCrypt;
import net.zaiyers.UUIDDB.lib.mongodb.crypt.capi.MongoCryptOptions;
import net.zaiyers.UUIDDB.lib.mongodb.crypt.capi.MongoCrypts;
import net.zaiyers.UUIDDB.lib.mongodb.internal.capi.MongoCryptHelper;

public final class Crypts {
    public static Crypt createCrypt(MongoClientImpl client, AutoEncryptionSettings settings) {
        MongoClient internalClient = null;
        MongoClientSettings keyVaultMongoClientSettings = settings.getKeyVaultMongoClientSettings();
        if (keyVaultMongoClientSettings == null || !settings.isBypassAutoEncryption()) {
            MongoClientSettings mongoClientSettings = MongoClientSettings.builder(client.getSettings()).applyToConnectionPoolSettings(builder -> builder.minSize(0)).autoEncryptionSettings(null).build();
            internalClient = MongoClients.create(mongoClientSettings);
        }
        MongoClient keyVaultClient = keyVaultMongoClientSettings == null ? internalClient : MongoClients.create(keyVaultMongoClientSettings);
        MongoCrypt mongoCrypt = MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings));
        return new Crypt(mongoCrypt, Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers(), settings.isBypassAutoEncryption(), settings.isBypassAutoEncryption() ? null : new CollectionInfoRetriever(internalClient), new CommandMarker(mongoCrypt, settings), internalClient);
    }

    static Crypt create(MongoClient keyVaultClient, ClientEncryptionSettings settings) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(settings)), Crypts.createKeyRetriever(keyVaultClient, settings.getKeyVaultNamespace()), Crypts.createKeyManagementService(settings.getKmsProviderSslContextMap()), settings.getKmsProviders(), settings.getKmsProviderPropertySuppliers());
    }

    private static KeyRetriever createKeyRetriever(MongoClient keyVaultClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap) {
        return new KeyManagementService(kmsProviderSslContextMap, 10000);
    }

    private Crypts() {
    }
}

