/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.mongodb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.zaiyers.UUIDDB.lib.mongodb.Tag;
import net.zaiyers.UUIDDB.lib.mongodb.annotations.Immutable;
import net.zaiyers.UUIDDB.lib.mongodb.assertions.Assertions;

@Immutable
public final class TagSet
implements Iterable<Tag> {
    private final List<Tag> wrapped;

    public TagSet() {
        this.wrapped = Collections.emptyList();
    }

    public TagSet(Tag tag) {
        Assertions.notNull("tag", tag);
        this.wrapped = Collections.singletonList(tag);
    }

    public TagSet(List<Tag> tagList) {
        Assertions.notNull("tagList", tagList);
        HashSet<String> tagNames = new HashSet<String>();
        for (Tag tag : tagList) {
            if (tag == null) {
                throw new IllegalArgumentException("Null tags are not allowed");
            }
            if (tagNames.add(tag.getName())) continue;
            throw new IllegalArgumentException("Duplicate tag names not allowed in a tag set: " + tag.getName());
        }
        ArrayList<Tag> copy = new ArrayList<Tag>(tagList);
        Collections.sort(copy, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.wrapped = Collections.unmodifiableList(copy);
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.wrapped.iterator();
    }

    public boolean containsAll(TagSet tagSet) {
        return this.wrapped.containsAll(tagSet.wrapped);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagSet tags = (TagSet)o;
        return this.wrapped.equals(tags.wrapped);
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public String toString() {
        return "TagSet{" + this.wrapped + '}';
    }
}

