/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.bson.internal;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.zaiyers.UUIDDB.lib.bson.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.bson.codecs.Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.UUIDDB.lib.bson.internal.CycleDetectingCodecRegistry;
import net.zaiyers.UUIDDB.lib.bson.internal.LazyCodec;

class ChildCodecRegistry<T>
implements CodecRegistry {
    private final ChildCodecRegistry<?> parent;
    private final CycleDetectingCodecRegistry registry;
    private final Class<T> codecClass;
    private final List<Type> types;

    ChildCodecRegistry(CycleDetectingCodecRegistry registry, Class<T> codecClass, List<Type> types) {
        this.codecClass = codecClass;
        this.parent = null;
        this.registry = registry;
        this.types = types;
    }

    private ChildCodecRegistry(ChildCodecRegistry<?> parent, Class<T> codecClass, List<Type> types) {
        this.parent = parent;
        this.codecClass = codecClass;
        this.registry = parent.registry;
        this.types = types;
    }

    public Class<T> getCodecClass() {
        return this.codecClass;
    }

    public Optional<List<Type>> getTypes() {
        return Optional.ofNullable(this.types);
    }

    public <U> Codec<U> get(Class<U> clazz) {
        if (this.hasCycles(clazz).booleanValue()) {
            return new LazyCodec<U>(this.registry, clazz, null);
        }
        return this.registry.get(new ChildCodecRegistry<U>(this, clazz, null));
    }

    public <U> Codec<U> get(Class<U> clazz, List<Type> typeArguments) {
        Assertions.notNull("typeArguments", typeArguments);
        Assertions.isTrueArgument("typeArguments is not empty", !typeArguments.isEmpty());
        Assertions.isTrueArgument(String.format("typeArguments size should equal the number of type parameters in class %s, but is %d", clazz, typeArguments.size()), clazz.getTypeParameters().length == typeArguments.size());
        if (this.hasCycles(clazz).booleanValue()) {
            return new LazyCodec<U>(this.registry, clazz, typeArguments);
        }
        return this.registry.get(new ChildCodecRegistry<U>(this, clazz, typeArguments));
    }

    public <U> Codec<U> get(Class<U> clazz, CodecRegistry registry) {
        return this.registry.get(clazz, registry);
    }

    private <U> Boolean hasCycles(Class<U> theClass) {
        ChildCodecRegistry<?> current = this;
        while (current != null) {
            if (current.codecClass.equals(theClass)) {
                return true;
            }
            current = current.parent;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChildCodecRegistry that = (ChildCodecRegistry)o;
        if (!this.codecClass.equals(that.codecClass)) {
            return false;
        }
        if (!Objects.equals(this.parent, that.parent)) {
            return false;
        }
        return this.registry.equals(that.registry);
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + this.registry.hashCode();
        result = 31 * result + this.codecClass.hashCode();
        return result;
    }
}

