/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.bson.codecs.jsr310;

import java.time.Instant;
import net.zaiyers.UUIDDB.lib.bson.BsonReader;
import net.zaiyers.UUIDDB.lib.bson.BsonWriter;
import net.zaiyers.UUIDDB.lib.bson.codecs.DecoderContext;
import net.zaiyers.UUIDDB.lib.bson.codecs.EncoderContext;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecConfigurationException;
import net.zaiyers.UUIDDB.lib.bson.codecs.jsr310.DateTimeBasedCodec;

public class InstantCodec
extends DateTimeBasedCodec<Instant> {
    @Override
    public Instant decode(BsonReader reader, DecoderContext decoderContext) {
        return Instant.ofEpochMilli(this.validateAndReadDateTime(reader));
    }

    @Override
    public void encode(BsonWriter writer, Instant value, EncoderContext encoderContext) {
        try {
            writer.writeDateTime(value.toEpochMilli());
        }
        catch (ArithmeticException e) {
            throw new CodecConfigurationException(String.format("Unsupported Instant value '%s' could not be converted to milliseconds: %s", value, e.getMessage()), e);
        }
    }

    @Override
    public Class<Instant> getEncoderClass() {
        return Instant.class;
    }
}

