/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.bson.codecs;

import java.util.HashMap;
import java.util.Map;
import net.zaiyers.UUIDDB.lib.bson.BsonArray;
import net.zaiyers.UUIDDB.lib.bson.BsonBinary;
import net.zaiyers.UUIDDB.lib.bson.BsonBoolean;
import net.zaiyers.UUIDDB.lib.bson.BsonDateTime;
import net.zaiyers.UUIDDB.lib.bson.BsonDbPointer;
import net.zaiyers.UUIDDB.lib.bson.BsonDecimal128;
import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonDocumentWrapper;
import net.zaiyers.UUIDDB.lib.bson.BsonDouble;
import net.zaiyers.UUIDDB.lib.bson.BsonInt32;
import net.zaiyers.UUIDDB.lib.bson.BsonInt64;
import net.zaiyers.UUIDDB.lib.bson.BsonJavaScript;
import net.zaiyers.UUIDDB.lib.bson.BsonJavaScriptWithScope;
import net.zaiyers.UUIDDB.lib.bson.BsonMaxKey;
import net.zaiyers.UUIDDB.lib.bson.BsonMinKey;
import net.zaiyers.UUIDDB.lib.bson.BsonNull;
import net.zaiyers.UUIDDB.lib.bson.BsonObjectId;
import net.zaiyers.UUIDDB.lib.bson.BsonRegularExpression;
import net.zaiyers.UUIDDB.lib.bson.BsonString;
import net.zaiyers.UUIDDB.lib.bson.BsonSymbol;
import net.zaiyers.UUIDDB.lib.bson.BsonTimestamp;
import net.zaiyers.UUIDDB.lib.bson.BsonType;
import net.zaiyers.UUIDDB.lib.bson.BsonUndefined;
import net.zaiyers.UUIDDB.lib.bson.BsonValue;
import net.zaiyers.UUIDDB.lib.bson.RawBsonDocument;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonArrayCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonBinaryCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonBooleanCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonDBPointerCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonDateTimeCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonDecimal128Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonDocumentCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonDocumentWrapperCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonDoubleCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonInt32Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonInt64Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonJavaScriptCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonJavaScriptWithScopeCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonMaxKeyCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonMinKeyCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonNullCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonObjectIdCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonRegularExpressionCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonStringCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonSymbolCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonTimestampCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonTypeClassMap;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonUndefinedCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonValueCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.RawBsonDocumentCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecProvider;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistry;

public class BsonValueCodecProvider
implements CodecProvider {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP;
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();

    public BsonValueCodecProvider() {
        this.addCodecs();
    }

    public static Class<? extends BsonValue> getClassForBsonType(BsonType bsonType) {
        return DEFAULT_BSON_TYPE_CLASS_MAP.get(bsonType);
    }

    public static BsonTypeClassMap getBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonJavaScriptWithScope.class) {
            return new BsonJavaScriptWithScopeCodec(registry.get(BsonDocument.class));
        }
        if (clazz == BsonValue.class) {
            return new BsonValueCodec(registry);
        }
        if (clazz == BsonDocumentWrapper.class) {
            return new BsonDocumentWrapperCodec(registry.get(BsonDocument.class));
        }
        if (clazz == RawBsonDocument.class) {
            return new RawBsonDocumentCodec();
        }
        if (BsonDocument.class.isAssignableFrom(clazz)) {
            return new BsonDocumentCodec(registry);
        }
        if (BsonArray.class.isAssignableFrom(clazz)) {
            return new BsonArrayCodec(registry);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public String toString() {
        return "BsonValueCodecProvider{}";
    }

    static {
        HashMap map = new HashMap();
        map.put(BsonType.NULL, BsonNull.class);
        map.put(BsonType.ARRAY, BsonArray.class);
        map.put(BsonType.BINARY, BsonBinary.class);
        map.put(BsonType.BOOLEAN, BsonBoolean.class);
        map.put(BsonType.DATE_TIME, BsonDateTime.class);
        map.put(BsonType.DB_POINTER, BsonDbPointer.class);
        map.put(BsonType.DOCUMENT, BsonDocument.class);
        map.put(BsonType.DOUBLE, BsonDouble.class);
        map.put(BsonType.INT32, BsonInt32.class);
        map.put(BsonType.INT64, BsonInt64.class);
        map.put(BsonType.DECIMAL128, BsonDecimal128.class);
        map.put(BsonType.MAX_KEY, BsonMaxKey.class);
        map.put(BsonType.MIN_KEY, BsonMinKey.class);
        map.put(BsonType.JAVASCRIPT, BsonJavaScript.class);
        map.put(BsonType.JAVASCRIPT_WITH_SCOPE, BsonJavaScriptWithScope.class);
        map.put(BsonType.OBJECT_ID, BsonObjectId.class);
        map.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        map.put(BsonType.STRING, BsonString.class);
        map.put(BsonType.SYMBOL, BsonSymbol.class);
        map.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        map.put(BsonType.UNDEFINED, BsonUndefined.class);
        DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap(map);
    }
}

