/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.bson.codecs;

import net.zaiyers.UUIDDB.lib.bson.BsonDocument;
import net.zaiyers.UUIDDB.lib.bson.BsonReader;
import net.zaiyers.UUIDDB.lib.bson.BsonWriter;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonDocumentCodec;
import net.zaiyers.UUIDDB.lib.bson.codecs.Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.DecoderContext;
import net.zaiyers.UUIDDB.lib.bson.codecs.EncoderContext;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecConfigurationException;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.UUIDDB.lib.bson.conversions.Bson;

public class BsonCodec
implements Codec<Bson> {
    private static final Codec<BsonDocument> BSON_DOCUMENT_CODEC = new BsonDocumentCodec();
    private final CodecRegistry registry;

    public BsonCodec(CodecRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Bson decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("The BsonCodec can only encode to Bson");
    }

    @Override
    public void encode(BsonWriter writer, Bson value, EncoderContext encoderContext) {
        try {
            BsonDocument bsonDocument = value.toBsonDocument(BsonDocument.class, this.registry);
            BSON_DOCUMENT_CODEC.encode(writer, bsonDocument, encoderContext);
        }
        catch (Exception e) {
            throw new CodecConfigurationException(String.format("Unable to encode a Bson implementation: %s", value), e);
        }
    }

    @Override
    public Class<Bson> getEncoderClass() {
        return Bson.class;
    }
}

