/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.bson.codecs;

import java.util.ArrayList;
import net.zaiyers.UUIDDB.lib.bson.BsonArray;
import net.zaiyers.UUIDDB.lib.bson.BsonReader;
import net.zaiyers.UUIDDB.lib.bson.BsonType;
import net.zaiyers.UUIDDB.lib.bson.BsonValue;
import net.zaiyers.UUIDDB.lib.bson.BsonWriter;
import net.zaiyers.UUIDDB.lib.bson.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.bson.codecs.BsonValueCodecProvider;
import net.zaiyers.UUIDDB.lib.bson.codecs.Codec;
import net.zaiyers.UUIDDB.lib.bson.codecs.DecoderContext;
import net.zaiyers.UUIDDB.lib.bson.codecs.EncoderContext;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistries;
import net.zaiyers.UUIDDB.lib.bson.codecs.configuration.CodecRegistry;

public class BsonArrayCodec
implements Codec<BsonArray> {
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private final CodecRegistry codecRegistry;

    public BsonArrayCodec() {
        this(DEFAULT_REGISTRY);
    }

    public BsonArrayCodec(CodecRegistry codecRegistry) {
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
    }

    @Override
    public BsonArray decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<BsonValue> list = new ArrayList<BsonValue>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.readValue(reader, decoderContext));
        }
        reader.readEndArray();
        return new BsonArray(list);
    }

    @Override
    public void encode(BsonWriter writer, BsonArray array, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (BsonValue value : array) {
            Codec<?> codec = this.codecRegistry.get(value.getClass());
            encoderContext.encodeWithChildContext(codec, writer, value);
        }
        writer.writeEndArray();
    }

    @Override
    public Class<BsonArray> getEncoderClass() {
        return BsonArray.class;
    }

    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        return (BsonValue)this.codecRegistry.get(BsonValueCodecProvider.getClassForBsonType(reader.getCurrentBsonType())).decode(reader, decoderContext);
    }
}

