/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.lib.bson;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.zaiyers.UUIDDB.lib.bson.BSONCallback;
import net.zaiyers.UUIDDB.lib.bson.BSONCallbackAdapter;
import net.zaiyers.UUIDDB.lib.bson.BSONDecoder;
import net.zaiyers.UUIDDB.lib.bson.BSONObject;
import net.zaiyers.UUIDDB.lib.bson.BasicBSONCallback;
import net.zaiyers.UUIDDB.lib.bson.Bits;
import net.zaiyers.UUIDDB.lib.bson.BsonBinaryReader;
import net.zaiyers.UUIDDB.lib.bson.BsonWriterSettings;
import net.zaiyers.UUIDDB.lib.bson.ByteBufNIO;
import net.zaiyers.UUIDDB.lib.bson.UuidRepresentation;
import net.zaiyers.UUIDDB.lib.bson.assertions.Assertions;
import net.zaiyers.UUIDDB.lib.bson.io.ByteBufferBsonInput;

public class BasicBSONDecoder
implements BSONDecoder {
    private static volatile UuidRepresentation defaultUuidRepresentation = UuidRepresentation.JAVA_LEGACY;

    public static void setDefaultUuidRepresentation(UuidRepresentation uuidRepresentation) {
        defaultUuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
    }

    public static UuidRepresentation getDefaultUuidRepresentation() {
        return defaultUuidRepresentation;
    }

    @Override
    public BSONObject readObject(byte[] bytes) {
        BasicBSONCallback bsonCallback = new BasicBSONCallback();
        this.decode(bytes, (BSONCallback)bsonCallback);
        return (BSONObject)bsonCallback.get();
    }

    @Override
    public BSONObject readObject(InputStream in) throws IOException {
        return this.readObject(this.readFully(in));
    }

    @Override
    public int decode(byte[] bytes, BSONCallback callback) {
        try (BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(new ByteBufNIO(ByteBuffer.wrap(bytes))));){
            BSONCallbackAdapter writer = new BSONCallbackAdapter(new BsonWriterSettings(), callback);
            writer.pipe(reader);
            int n = reader.getBsonInput().getPosition();
            return n;
        }
    }

    @Override
    public int decode(InputStream in, BSONCallback callback) throws IOException {
        return this.decode(this.readFully(in), callback);
    }

    private byte[] readFully(InputStream input) throws IOException {
        byte[] sizeBytes = new byte[4];
        Bits.readFully(input, sizeBytes);
        int size = Bits.readInt(sizeBytes);
        byte[] buffer = new byte[size];
        System.arraycopy(sizeBytes, 0, buffer, 0, 4);
        Bits.readFully(input, buffer, 4, size - 4);
        return buffer;
    }
}

